module yamalib.gui.keygroup;

private import ytl.vector;
private import yamalib.gui.guiparts;

/**
	IGUIPartsに対して、タブグループのような機構を実現するクラス
*/
public class KeyGroup {

	/// タブグループに追加
	void add(IGUIParts parts) {
		m_list.push_back(parts);
	}
	
	/// 次のパーツをフォーカス
	void next() {
		if ( !m_list.empty() ) {
			++m_index;
			if (m_list.size() <= m_index) {
				m_index = 0;
			}
			m_list[m_index].focus();
		}
	}
	
	/// 前のパーツをフォーカス
	void prev() {
		if ( !m_list.empty() ) {
			--m_index;
			if (0 > m_index) {
				m_index = m_list.size() - 1;
			}
			m_list[m_index].focus();
		}
	}
	
	/// 要素のインデックスを指定してそのパーツをフォーカス
	void focus(int no) {
		if (no < 0 || m_list.size() <= no) {
			return;
		}
		m_index = no;
		m_list[no].focus();
	}

	/// 要素のインデックスを指定してそのパーツをフォーカス
	void focus(IGUIParts target) {
		if (m_list.empty()) {
			return;
		}
		foreach (int i,inout IGUIParts parts; m_list) {
			if (parts is target) {
				focus(i);
				break;
			}
		}
	}
	
	/// 上のfocusでは、マウス移動するが、こっちは、内部的な移動だけで、マウスは移動させない
	void setSelectNo(int no) {
		if (no < 0 || m_list.size() <= no) {
			return;
		}
		m_index = no;
	}
	/// 内部的な移動だけ
	void setSelectNo(IGUIParts target) {
		if (m_list.empty()) {
			return;
		}
		foreach (int i,inout IGUIParts parts; m_list) {
			if (parts is target) {
				setSelectNo(i);
				break;
			}
		}
	}
	
	/// 今フォーカスしているインデックス番号を取得する
	int getFocusNo() {
		return this.m_index;
	}
	
	/// 全てのキーグループを解除する
	void clear() {
		m_list.clear();
		m_index = 0;
	}
	
	/// コンストラクタ
	this() {
		m_list = new vector!(IGUIParts);
	}
	
private:
	 vector!(IGUIParts) m_list;
	 int m_index;

}