﻿module y4d_timer.fixtimer;
private import y4d_timer.timer;

///	ゲームで使用する1フレーム間は同じ値の返るタイマ。
/**
	ゲームで class Timer を使う場合、
	１フレームの間は、固定値が返ってきたほうが望ましい。
*/
class FixTimer {

	///	現在の時刻を0に
	void	reset() { timer.reset(); dwTimeGetTime=0; }

	///	現在の時刻の取得
	uint	get() { return dwTimeGetTime; }

	///	現在の時刻の設定
	void	set(uint t){ timer.set(t); }

	///	Pause機能
	void	pause() { timer.pause(); }

	///	Pause解除
	void	restart() { timer.restart(); }

	///	時刻を更新する
	void	update()
	/**
		これをした瞬間の時刻値に基づいてGetで値が返るようになる。
		以降、再度この関数を呼び出すまで、updateと同じ値が返る
		この関数以外は、class Timer と同じ
	*/
	{ dwTimeGetTime = timer.get(); }

	this() { timer = new Timer; dwTimeGetTime = 0; }

protected:
	Timer	timer;
	uint		dwTimeGetTime;				//	前回Flushした時間
}
