﻿module yamalib.draw.prmptcarsor;

private import y4d;
private import yamalib.counterfsp;


/// プロンプトカーソル描画クラス
/**
	仮想のプロンプトカーソルを描画
	表示状態から描画開始し、カーソルの残像も描画します。
*/
class PromptCarsor {
	
	/// コンストラクタ
	this() {
		blink = 20;
		dispflame = 5;
		nondispflame = 5;
		blend = true;
		disp = true;
		alpha = new RootCounter;
		alpha.setReverse(true);
		alpha.set(0,255,1);
		calcAlphaStep();
		alpha.opAssign(255);
	}

	/// プロンプトカーソル用のテクスチャを設定します
	/*
		これを設定しなければ、内部で白いテクスチャを生成し、それを使用する
	*/
	void setTexture(Texture t) { carsor = t; }

	/// 明滅の１周期フレーム数
	void setBlinkSpeed(int speed) {
		blink = speed;
	}

	/// 明滅周期中のカーソルを完全表示(α=255)表示時間
	void setDispFlame(int flame) {
		if (flame>blink) {
			dispflame = blink;
		} else {
			dispflame = flame;
		}
	}

	/// 周期中の中で、プロンプトカーソルが表示されていないフレーム数の設定
	void setNonDispFlame(int flame) {
		nondispflame = flame;
	}

	/// 表示位置の設定
	void setXY(int x_,int y_) {
		x = x_;
		y = y_;
	}

	/// 表示位置の取得
	void getXY(out int x_,out int y_) {
		x_ = x;
		y_ = y;
	}

	/// ブレンドするか
	void setBlend(bool b) { blend = b; }

	/// 状態を初期化
	void reset() {
		flamecounter = 0;
	}

	/// 毎回呼び出す
	void onDraw(Screen screen) {
		if (carsor is null) return;

		if(!disp) {
			dispcounter++;
			if (dispcounter>=nondispflame) {
				disp = true;
				dispcounter = 0;
			}
			return;
		}

		if (flamecounter < dispflame) {
			screen.blendAddColorAlpha();
			screen.blt(carsor,x,y);
		} else {
			alpha++;
			if (blend) {
				screen.blendAddColorAlpha();
				screen.setColor(255,255,255,alpha.get());
				screen.blt(carsor,x,y);
			} else {
			}
		}

		// 使ったら元に戻しとけ
		screen.resetColor();

		flamecounter++;

		if (flamecounter >= blink) {
			flamecounter = 0;
			alpha.reset();
			alpha.opAssign(255);
//			disp = false;
		}
	}
private:

	void calcAlphaStep() {
		int n = blink-dispflame;
		int step = 255/n;
		alpha.setStep(step);
	}
	
private:
	Texture carsor;		//!< カーソル画像
	int x,y;			//!< 描画位置
	int blink;			//!< 点滅速度
	int dispflame;		//!< 表示フレーム数
	int nondispflame;	//!< 非表示フレーム数
	bool blend;			//!< ブレンドするか
	bool disp;			//!< 表示中か

	RootCounter alpha;
	int flamecounter;
	int dispcounter;
}