﻿module yamalib.auxil.encryption;

private import yamalib.log.log;

/**
	暗号化クラス
	これらは、可逆である暗号化関数を提供する
*/
class Encryption {

public:
	/* エンコードするタイプを表す */	
	enum TYPE : int {
		ROW_DATA=0,	// エンコードしない
		XOR			// XOR暗号／復号化
	}

	/// XOR 暗号化を行う
	static void encXOR(out ubyte[] enc, ubyte[] data, ubyte key) 
	/**
		XOR暗号化だからして、機密性はかなり低いので、
		とりあえず、生データがみえなければ、というレベルで考えること。
	*/
	{
		foreach (inout ubyte d; data) {
			enc ~= (d ^ key);
		}
		
//		Log.print("XOR Encorded.");
	}
	
	/// XOR暗号化されたものの復号化
	static void decXOR(out ubyte[] dec, ubyte[] data, ubyte key) {
		foreach (inout ubyte d; data) {
			dec ~= (d ^ key);
		}
	}
	
private:
	this() {
	}
}