// ----------------------------------------------------------
// v0.91
// http://www.neuropolis.org/project/lua_from_d/
// Converted from lua.h by lunakid@neuropolis.org
// Thanks to Shinichiro Hamaji for bug-fixes!
//
public import lua;


struct luaL_reg {
  char *name;
  lua_CFunction func;
};


extern (C)
{
void luaL_openlib (lua_State L, char* libname, luaL_reg* l, int nup);
int luaL_getmetafield (lua_State L, int obj, char* e);
int luaL_callmeta (lua_State L, int obj, char* e);
int luaL_typerror (lua_State L, int narg, char* tname);
int luaL_argerror (lua_State L, int numarg, char* extramsg);
char* luaL_checklstring (lua_State L, int numArg, uint* l);
char* luaL_optlstring (lua_State L, int numArg, char* def, uint *l);
lua_Number luaL_checknumber (lua_State L, int numArg);
lua_Number luaL_optnumber (lua_State L, int nArg, lua_Number def);

void luaL_checkstack (lua_State L, int sz, char* msg);
void luaL_checktype (lua_State L, int narg, int t);
void luaL_checkany (lua_State L, int narg);

int   luaL_newmetatable (lua_State L, char* tname);
void  luaL_getmetatable (lua_State L, char* tname);
void* luaL_checkudata (lua_State L, int ud, char* tname);

void luaL_where (lua_State L, int lvl);
int luaL_error (lua_State L, char* fmt, ...);

int luaL_findstring (char* st, char* lst[]);

int  luaL_ref (lua_State L, int t);
void luaL_unref (lua_State L, int t, int ref);

int  luaL_getn (lua_State L, int t);
void luaL_setn (lua_State L, int t, int n);

int luaL_loadfile (lua_State L, char* filename);
int luaL_loadbuffer (lua_State L, char* buff, uint sz, char* name);
}


/*
** ===============================================================
** some useful macros
** ===============================================================
*/

int   luaL_argcheck(lua_State L, int cond, int numarg, char* extramsg)
	{ if (!cond) return luaL_argerror(L, numarg, extramsg); }

char* luaL_checkstring(lua_State L, int n)
	{ return luaL_checklstring(L, n, null); }

char* luaL_optstring(lua_State L, int n, char* d)
	{ return luaL_optlstring(L, n, d, null); }

int   luaL_checkint(lua_State L, int n)
	{ return (int)luaL_checknumber(L, n); }

long luaL_checklong(lua_State L, int n)
	{ return (long)luaL_checknumber(L, n); }

int luaL_optint(lua_State L, int n, int d)
	{ return (int)luaL_optnumber(L, n, (lua_Number)d); }

long luaL_optlong(lua_State L, int n, int d)
	{ return (long)luaL_optnumber(L, n,(lua_Number)d); }


/*
** {======================================================
** Generic Buffer manipulation
** =======================================================
*/

/*!! BUFSIZ is actually defined in stdio.h...
#ifndef LUAL_BUFFERSIZE
#define LUAL_BUFFERSIZE	  BUFSIZ
#endif
!!*/
const int	LUAL_BUFFERSIZE = 8192;

struct luaL_Buffer {
  char* p;			/* current position in buffer */
  int lvl;  /* number of strings in the stack (level) */
  lua_State L;
  char buffer[LUAL_BUFFERSIZE];
};

char luaL_putchar(luaL_Buffer* B, char c) {
	if (B.p >= &B.buffer[0] + LUAL_BUFFERSIZE) luaL_prepbuffer(B);
	return *(B.p++) = c;
}

char* luaL_addsize(luaL_Buffer* B, int n)	{ return B.p += n; }

extern (C)
{
void  luaL_buffinit (lua_State L, luaL_Buffer* B);
char* luaL_prepbuffer (luaL_Buffer* B);
void  luaL_addlstring (luaL_Buffer* B, char* s, uint l);
void  luaL_addstring (luaL_Buffer* B, char* s);
void  luaL_addvalue (luaL_Buffer* B);
void  luaL_pushresult (luaL_Buffer* B);
}

/* }====================================================== */


/*
** Compatibility macros and functions
*/

extern (C)
{
int   lua_dofile (lua_State L, char* filename);
int   lua_dostring (lua_State L, char* str);
int   lua_dobuffer (lua_State L, char* buff, uint sz, char* n);
}

alias  	luaL_checklstring  luaL_check_lstr;
alias   luaL_optlstring    luaL_opt_lstr;
alias   luaL_checknumber   luaL_check_number;
alias  	luaL_optnumber     luaL_opt_number;
alias  	luaL_argcheck      luaL_arg_check;
alias  	luaL_checkstring   luaL_check_string;
alias  	luaL_optstring     luaL_opt_string;
alias  	luaL_checkint      luaL_check_int;
alias  	luaL_checklong     luaL_check_long;
alias  	luaL_optint        luaL_opt_int;
alias  	luaL_optlong       luaL_opt_long;
