/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
/**
 * Compact events are to be delivered when:
 * 1. the application is in idle state for long duration
 * 2. the application had been deactivated ( application has lost the focus )
 * 3. the application had been minimized
 * these are to reduce memory usage, like garbage collection, cache cleaning,
 * or etc ...
 */
package jp.kirikiri.tvp2.base;

import java.util.ArrayList;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;

/**
 *
 */
public class CompactEvent {
	private ArrayList<CompactEventCallbackInterface> mCompactEventVector;
	public CompactEvent() {
		mCompactEventVector = new ArrayList<CompactEventCallbackInterface>();
	}
	public void addCompactEventHook(CompactEventCallbackInterface callback) {
		mCompactEventVector.add(callback);
	}
	public void removeCompactEventHook(CompactEventCallbackInterface callback) {
		final int count = mCompactEventVector.size();
		for( int i = 0; i < count; i++ ) {
			CompactEventCallbackInterface itf = mCompactEventVector.get(i);
			if( itf == callback ) {
				mCompactEventVector.set( i, null );
			}
		}
	}
	public void deliverCompactEvent( int level ) {
		// must be called by each platforms's implementation
		final int count = mCompactEventVector.size();
		if( count > 0 ) {
			boolean emptyflag = false;
			for( int i = 0; i < count; i ++) {
				// note that the handler can remove itself while the event
				try {
					try {
						CompactEventCallbackInterface itf = mCompactEventVector.get(i);
						if( itf != null )
							itf.onCompact(level);
						else
							emptyflag = true;
					} catch( TJSScriptException e ) {
						throw e;
					} catch( TJSScriptError e ) {
						throw e;
					} catch( TJSException e) {
						throw e;
					} catch( Exception e ) {
						throw new TJSException(e.getMessage());
					}
				} catch(TJSScriptError e) {
					e.addTrace( "Compact Event" );
					ScriptsClass.showScriptException(e);
				} catch( TJSException e ) {
					ScriptsClass.showScriptException(e);
				}
			}

			if( emptyflag ) {
				// the array has empty cell
				// eliminate empty
				for( int i = count-1; i >= 0; i-- ) {
					CompactEventCallbackInterface itf = mCompactEventVector.get(i);
					if( itf == null ) mCompactEventVector.remove(i);
				}
			}
		}
	}
}
