/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

public class LocalNamespace {
	private VectorWrap<LocalSymbolList> mLevels;
	private int mMaxCount;
	private int mCurrentCount;
	private MaxCountWriter mMaxCountWriter;

	public LocalNamespace() {
		//mMaxCount = 0;
		//mCurrentCount = 0;
		mLevels = new VectorWrap<LocalSymbolList>();
	}
	public void setMaxCountWriter( MaxCountWriter writer ) {
		mMaxCountWriter = writer;
	}
	public int getCount() {
		int count = 0;
		final int size = mLevels.size();
		for( int i = 0; i < size; i++ ) {
			LocalSymbolList list = mLevels.get(i);
			count += list.getCount();
		}
		return count;
	}
	public void push() {
		mCurrentCount = getCount();
		mLevels.add( new LocalSymbolList(mCurrentCount) );
	}
	public void pop() {
		LocalSymbolList list = mLevels.lastElement();
		commit();
		mCurrentCount = list.getLocalCountStart();
		mLevels.remove(mLevels.size()-1);
		list = null;
	}
	public int find( final String name ) {
		final int count = mLevels.size();
		for( int i = count-1; i >= 0; i-- ) {
			LocalSymbolList list = mLevels.get(i);
			int lindex = list.find( name );
			if( lindex != -1 ) {
				return lindex + list.getLocalCountStart();
			}
		}
		return -1;
	}
	public int getLevel() { return mLevels.size(); }
	public void add( final String name ) {
		LocalSymbolList top = getTopSymbolList();
		if( top == null ) return;
		top.add( name );
	}
	public void remove( final String name ) {
		final int count = mLevels.size();
		for( int i = count-1; i >= 0; i-- ) {
			LocalSymbolList list = mLevels.get(i);
			int lindex = list.find( name );
			if( lindex != -1 ) {
				list.remove( lindex );
				return;
			}
		}
	}
	public void commit() {
		int count = 0;
		for( int i = mLevels.size()-1; i >= 0; i-- ) {
			LocalSymbolList list = mLevels.get(i);
			count += list.getCount();
		}
		if( mMaxCount < count ) {
			mMaxCount = count;
			if( mMaxCountWriter != null ) mMaxCountWriter.setMaxCount(count);
		}
	}
	public LocalSymbolList getTopSymbolList() {
		if( mLevels.size() == 0 ) return null;
		return mLevels.lastElement();
	}
	public void clear() {
		while( mLevels.size() > 0 ) pop();
	}
	public int getMaxCount() { return mMaxCount; }
}
