package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntVector;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.Variant;

public class KAGParserNI extends NativeInstanceObject {

	private static final int MEMBERENSURE = 0x00000200;

	private Dispatch2 mOwner; // owner object

	private Dispatch2 mDicClear; // Dictionary.Clear method pointer
	private Dispatch2 mDicAssign; // Dictionary
	private Dispatch2 mDicObj; // DictionaryObject

	private Dispatch2 mMacros; // Macro Dictionary Object

	private ArrayList<Dispatch2> mMacroArgs; // Macro arguments
	private int mMacroArgStackDepth;
	private int MacroArgStackBase;

	static class CallStackData {
		public String Storage; // caller storage
		public String Label; // caller nearest label
		public int Offset; // line offset from the label
		public String OrgLineStr; // original line string
		public String LineBuffer; // line string (if alive)
		public int Pos;
		public boolean LineBufferUsing; // whether LineBuffer is used or not
		public int MacroArgStackBase;
		public int MacroArgStackDepth;
		public IntVector ExcludeLevelStack;
		public ArrayList<Boolean> IfLevelExecutedStack;
		public int ExcludeLevel;
		public int IfLevel;

		public CallStackData( final String storage, final String label,
			int offset, final String orglinestr, final String linebuffer,
			int pos, boolean linebufferusing, int macroargstackbase,
			int macroargstackdepth,
			final IntVector excludelevelstack, int excludelevel,
			final ArrayList<Boolean> iflevelexecutedstack, int iflevel) {

			Storage = storage;
			Label = label;
			Offset = offset;
			OrgLineStr = orglinestr;
			LineBuffer = linebuffer;
			Pos = pos;
			LineBufferUsing = linebufferusing;
			MacroArgStackBase = macroargstackbase;
			MacroArgStackDepth = macroargstackdepth;
			ExcludeLevelStack = excludelevelstack;
			ExcludeLevel = excludelevel;
			IfLevelExecutedStack = iflevelexecutedstack;
			IfLevel = iflevel;
		}
	}
	private ArrayList<CallStackData> mCallStack;

	/*
	private ScenarioCacheItem mScenario;
	private ScenarioCacheItem::Line mLines; // is copied from Scenario
	private int mLineCount; // is copied from Scenario

	private String mStorageName;
	private String mStorageShortName;

	private int mCurLine; // current processing line
	private int mCurPos; // current processing position ( column )
	private String mCurLineStr; // current line string
	private String mLineBuffer; // line buffer ( if any macro/emb was expanded )
	private boolean mLineBufferUsing;
	private String mCurLabel; // Current Label
	private String mCurPage; // Current Page Name
	private int mTagLine; // line number of previous tag

	private KAGDebugLevel mDebugLevel; // debugging log level
	private boolean mProcessSpecialTags; // whether to process special tags
	private boolean mIgnoreCR; // CR is not interpreted as [r] tag when this is true
	private boolean mRecordingMacro; // recording a macro
	private String mRecordingMacroStr; // recording macro content
	private String mRecordingMacroName; // recording macro's name

	private Variant mValueVariant;

	private int mExcludeLevel;
	private int mIfLevel;

	private ArrayList<Integer> mExcludeLevelStack;
	private ArrayList<Boolean> mIfLevelExecutedStack;

	private boolean mInterrupted;

	public KAGParserNI() {
		mOwner = null;
		mScenario = null;
		mLines = null;
		mCurLineStr = null;
		mProcessSpecialTags = true;
		mIgnoreCR = false;
		mDicClear = null;
		mDicAssign = null;
		mDicObj = null;
		mMacros = null;
		mRecordingMacro = null;
		mDebugLevel = tkdlSimple;
		mInterrupted = false;
		mMacroArgStackDepth = 0;
		mMacroArgStackBase = 0;

		// retrieve DictClear method and DictObj object
		Holder<Dispatch2> holder = new Holder<Dispatch2>(null);
		mDicObj = TJS.createDictionaryObject(holder);
		mMacros = TJS.createDictionaryObject();
		Dispatch2 dictclass = holder.mValue;
		holder.mValue = null;
		try {
			// retrieve clear method from dictclass
			Variant val = new Variant();
			int er;

			er = dictclass.propGet( 0, "clear", val, dictclass );
			if( er < 0 ) TVPThrowInternalError;
			mDicClear = val.asObject();

			er = dictclass.propGet( 0, "assign", val, dictclass );
			if( er < 0 ) TVPThrowInternalError;
			mDicAssign = val.asObject();
		} catch(...) {
			dictclass = null;
			mDicObj = null;
			mMacros = null;
			mDicClear = null;
			mDicAssign = null;
			throw;
		}
		dictclass = null;
	}
	public int construct( Variant[] param, Dispatch2 tjsObj ) {
		int hr = super.construct( param, tjsObj );
		if( hr < 0 ) return hr;

		mOwner = tjsObj;
		return S_OK;
	}
	// called before destruction
	public void invalidate() {
		// invalidate this object

		// release objects
		mDicAssign = null;
		mDicClear = null;
		mDicObj = null;
		mMacros = null;

		clearMacroArgs();
		clearBuffer();
		mOwner = null;
		super.invalidate();
	}
	public void copy( final KAGParserNI ref ) {
		// copy Macros
		Variant[] psrc = new Variant[1];
		{
			Variant src = new Variant(ref.mMacros, ref.mMacros);
			psrc[0] = src;
			mDicAssign.funcCall( 0, null, null, psrc, mMacros );
		}

		// copy MacroArgs
		{
			clearMacroArgs();

			for( int i = 0; i < ref.mMacroArgStackDepth; i++ ) {
				Dispatch2 dic = TJS.createDictionaryObject();
				Dispatch2 isrc = ref.mMacroArgs.get(i);
				Variant src = new Variant(isrc, isrc);
				psrc[0] = src;
				mDicAssign.funcCall( 0, null, null, psrc, dic );
				mMacroArgs.add(dic);
			}
			mMacroArgStackDepth = ref.mMacroArgStackDepth;
		}
		mMacroArgStackBase = ref.mMacroArgStackBase;

		// copy CallStack
		// TODO コピーすること
		mCallStack = ref.mCallStack.clone();

		// copy StorageName, StorageShortName
		mStorageName = new String(ref.mStorageName);
		mStorageShortName = new String(ref.mStorageShortName);


		// copy Scenario
		if( mScenario != ref.mScenario ) {
			if( mScenario != null ) {
				mScenario = null;
				mLines = null;
				mCurLineStr = null;
			}
			mScenario = ref.mScenario;
			mLines = ref.mLines;
			mLineCount = ref.mLineCount;
		}

		// copy CurStorage, CurLine, CurPos
		mCurLine = ref.mCurLine;
		mCurPos = ref.mCurPos;

		// copy CurLineStr, LineBuffer, LineBufferUsing
		mCurLineStr = ref.mCurLineStr;
		mLineBuffer = new String(ref.mLineBuffer);
		mLineBufferUsing = ref.mLineBufferUsing;

		// copy CurLabel, CurPage, TagLine
		mCurLabel = new String(ref.mCurLabel);
		mCurPage = new String(ref.mCurPage);
		mTagLine = ref.mTagLine;

		// copy DebugLebel, IgnoreCR
		mDebugLevel = ref.mDebugLevel;
		mIgnoreCR = ref.mIgnoreCR;

		// copy RecordingMacro, RecordingMacroStr, RecordingMacroName
		mRecordingMacro = ref.mRecordingMacro;
		mRecordingMacroStr = new String(ref.mRecordingMacroStr);
		mRecordingMacroName = new String(ref.mRecordingMacroName);

		// copy ExcludeLevel, IfLevel
		mExcludeLevel = ref.mExcludeLevel;
		mIfLevel = ref.mIfLevel;
		mExcludeLevelStack = ref.mExcludeLevelStack; // TODO コピーすること
		mIfLevelExecutedStack = ref.mIfLevelExecutedStack; // TODO コピーすること
	}

	public Dispatch2 store() {
		// store current status into newly created dictionary object
		// and return the dictionary object.
		Dispatch2 dic = TJS.createDictionaryObject();
		{
			Variant val = new Variant();

			Variant[] psrc = new Variant[1];
			// create and assign macro dictionary
			{
				Dispatch2 dsp;

				dsp = TJS.createDictionaryObject();
				Variant tmp = new Variant(dsp, dsp);
				dic.propSet( MEMBERENSURE, "macros", tmp, dic );

				Variant src = new Variant(mMacros, mMacros);
				psrc[0] = src;
				mDicAssign.funcCall( 0, null, null, psrc, dsp );
			}

			// create and assign macro arguments
			{
				Dispatch2 dsp;
				dsp = TJS.createArrayObject();
				Variant tmp = new Variant(dsp, dsp);
				dic.propSet( MEMBERENSURE, "macroArgs", tmp, dic );

				for( int i = 0; i < mMacroArgStackDepth; i++ ) {
					Dispatch2 dic1;
					dic1 = TJS.createDictionaryObject();
					tmp.set(dic1, dic1);
					dsp.propSetByNum( MEMBERENSURE, i, tmp, dsp );

					Dispatch2 isrc = mMacroArgs.get(i);
					Variant src = new Variant(isrc, isrc);
					psrc[0] = src;
					mDicAssign.funcCall( 0, null, null, psrc, dic1 );
				}
			}


			// create call stack array and copy call stack status
			{
				Dispatch2 dsp;
				dsp = TJS.createArrayObject();
				Variant tmp = new Variant(dsp, dsp);
				dic.propSet( MEMBERENSURE, "callStack", tmp, dic);

				final int size = mCallStack.size();
				for( int i = 0; i < size; i++ ) {
					CallStackData d = mCallStack.get(i);

					Dispatch2 dic1;
					dic1 = TJS.createDictionaryObject();
					tmp.set(dic1, dic1);
					dsp.propSetByNum( MEMBERENSURE, i, tmp, dsp );

					val.set( d.Storage );
					dic1.propSet( MEMBERENSURE, "storage", val, dic1 );

					val.set( d.Label );
					dic1.propSet( MEMBERENSURE, "label", val, dic1 );
					val.set( d.Offset );
					dic1.propSet( MEMBERENSURE, "offset", val, dic1);
					val.set( d.OrgLineStr );
					dic1.propSet (MEMBERENSURE, "orgLineStr", val, dic1);
					val.set( d.LineBuffer );
					dic1.propSet( MEMBERENSURE, "lineBuffer", val, dic1);
					val.set( d.Pos );
					dic1.propSet( MEMBERENSURE, "pos", val, dic1);
					val.set( d.LineBufferUsing ? 1 : 0 );
					dic1.propSet( MEMBERENSURE, "lineBufferUsing", val, dic1);
					val.set( d.MacroArgStackBase );
					dic1.propSet( MEMBERENSURE, "macroArgStackBase", val, dic1);
					val.set( d.MacroArgStackDepth );
					dic1.propSet( MEMBERENSURE, "macroArgStackDepth", val, dic1);
					val.set( d.ExcludeLevel );
					dic1.propSet( MEMBERENSURE, "ExcludeLevel", val, dic1);
					val.set( d.IfLevel );
					dic1.propSet( MEMBERENSURE, "IfLevel", val, dic1);

					storeIntStackToDic( dic1, d.ExcludeLevelStack, "ExcludeLevelStack" );
					storeBoolStackToDic( dic1, d.IfLevelExecutedStack, "IfLevelExecutedStack" );
				}
			}

			// store StorageName, StorageShortName ( Buffer is not stored )
			val.set( mStorageName );
			dic.propSet( MEMBERENSURE, "storageName", val, dic);
			val.set( mStorageShortName );
			dic.propSet( MEMBERENSURE, "storageShortName", val, dic);

			// ( Lines and LineCount are not stored )

			// store CurStorage, CurLine, CurPos
			val.set( mCurLine );
			dic.propSet( MEMBERENSURE, "curLine", val, dic);
			val.set( mCurPos );
			dic.propSet( MEMBERENSURE, "curPos", val, dic);

			// ( CurLineStr is not stored )

			// LineBuffer, LineBufferUsing
			val.set( mLineBuffer );
			dic.propSet( MEMBERENSURE, "lineBuffer", val, dic);
			val.set( mLineBufferUsing ? 1 : 0 );
			dic.propSet( MEMBERENSURE, "lineBufferUsing", val, dic);

			// store CurLabel ( CurPage TagLine is not stored )
			val.set( mCurLabel );
			dic.propSet( MEMBERENSURE, "curLabel", val, dic);

			// ( DebugLebel and IgnoreCR are not stored )

			// ( RecordingMacro, RecordingMacroStr, RecordingMacroName are not stored)


			// ExcludeLevel, IfLevel, ExcludeLevelStack, IfLevelExecutedStack
			val.set( mExcludeLevel );
			dic.propSet( MEMBERENSURE, "ExcludeLevel", val, dic);
			val.set( mIfLevel );
			dic.propSet( MEMBERENSURE, "IfLevel", val, dic);
			storeIntStackToDic(dic, mExcludeLevelStack, "ExcludeLevelStack");
			storeBoolStackToDic(dic, mIfLevelExecutedStack, "IfLevelExecutedStack");

			// store MacroArgStackBase, MacroArgStackDepth
			val.set( mMacroArgStackBase );
			dic.propSet( MEMBERENSURE, "macroArgStackBase", val, dic );

			val.set( mMacroArgStackDepth );
			dic.propSet( MEMBERENSURE, "macroArgStackDepth", val, dic );
		}
		{
			dic = null;
		}
		return dic;
	}
	*/
}

