package jp.kirikiri.tjs2;


public class RandomGeneratorClass extends NativeClass {

	static private final int
		S_OK = 0,
		E_NATIVECLASSCRASH = -1008;
	static private final int NIS_GETINSTANCE = 0x00000002; // get native pointer
	public static int mClassID;
	static private final String CLASS_NAME = "RandomGenerator";
	static final private int nitMethod	= 1;

	protected NativeInstance createNativeInstance() {
		return new RandomGeneratorNI();
	}
	public static RandomGeneratorNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (RandomGeneratorNI) holder.mValue;
	}
	public RandomGeneratorClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				RandomGeneratorNI _this;
				Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
				int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
				_this = (RandomGeneratorNI) holder.mValue;
				if( hr < 0 ) return E_NATIVECLASSCRASH;
				if( _this == null ) return E_NATIVECLASSCRASH;
				hr = _this.construct( param, objthis );
				if( hr < 0 ) return hr;

				_this.randomize( param );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "randomize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.randomize( param );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "random", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				// returns 53-bit precision random value x, x is in 0 <= x < 1
				if( result != null ) {
					result.set( _this.random() );
				} else {
					_this.random();
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "random32", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				// returns 32-bit precision integer value x, x is in 0 <= x <= 4294967295
				if( result != null ) {
					result.set( _this.random32() );
				} else {
					_this.random32();
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "random63", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				// returns 63-bit precision integer value x, x is in 0 <= x <= 9223372036854775807
				if( result != null ) {
					result.set( _this.random63() );
				} else {
					_this.random63();
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "random64", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				// returns 64-bit precision integer value x, x is in
				// -9223372036854775808 <= x <= 9223372036854775807
				// Java 実装では、int は32 bitまで
				if( result != null ) {
					result.set( _this.random64() );
				} else {
					_this.random64();
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "serialize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
				if( _this == null ) return E_NATIVECLASSCRASH;
				// returns 64-bit precision integer value x, x is in
				// -9223372036854775808 <= x <= 9223372036854775807
				if( result != null ) {
					Dispatch2 dsp = _this.serialize();
					result.set( dsp, dsp );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );
	}
}
