/*
 * TODO 未テスト
 */
package jp.kirikiri.tjs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class NativeJavaClassMethod extends Dispatch {

	private static final int S_OK = 0;
	private static final int S_TRUE = 1;
	private static final int
		E_NATIVECLASSCRASH = (-1008),
		E_INVALIDPARAM = (-1003),
		E_ACCESSDENYED = (-1007);

	static private final int NIS_GETINSTANCE = 0x00000002; // get native pointer

	private Method mProcess;
	private int mClassID;

	private Class<?>[] mParamTypes;
	private Class<?> mReturnType;
	private boolean mIsStatic;

	public NativeJavaClassMethod( Method m, int classID ) throws TJSException {
		mProcess = m;
		mClassID = classID;
		if( m == null ) throw new TJSException( Error.InternalError );

		mParamTypes = m.getParameterTypes();
		mReturnType = m.getReturnType();
		if( Modifier.isStatic( m.getModifiers() ) ) mIsStatic = true;
	}

	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Function".equals(classname) ) return S_TRUE;
		}
		int ret = super.isInstanceOf(flag, membername, classname, objthis);
		return ret;
	}
	public int funcCall( int flag, final String membername, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.funcCall(flag, membername, result, param, objthis);
		if( param.length < mParamTypes.length ) return E_INVALIDPARAM; // パラメータが少ない

		if( result != null ) result.clear();

		Object self;
		if( mIsStatic ) {
			self = null; // static 時は null
		} else {
			if( objthis == null ) return E_NATIVECLASSCRASH;
			Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
			int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
			if( hr < 0 ) return hr;
			NativeJavaInstance ni = (NativeJavaInstance)holder.mValue;
			self = ni.getNativeObject();
			if( self == null ) return E_NATIVECLASSCRASH;
		}

		int er = S_OK;
		Object[] args = NativeJavaClass.variantArrayToJavaObjectArray( param, mParamTypes );
		try {
			Object ret = mProcess.invoke( self, args );
			if( result != null ) NativeJavaClass.javaObjectToVariant( result, mReturnType, ret );
		} catch (IllegalArgumentException e) {
			er = E_INVALIDPARAM;
		} catch (IllegalAccessException e) {
			er = E_ACCESSDENYED;
		} catch (InvocationTargetException e) {
			Throwable t = e.getCause();
			if( t instanceof VariantException ) {
				throw (VariantException)t;
			} else if( t instanceof TJSException ) {
				throw (TJSException)t;
			} else {
				throw new TJSException( t.toString() );
			}
		}
		return er;
	}
}
