package jp.kirikiri.tvp2.env;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import jp.kirikiri.tvp2.sound.WaveSoundBufferNI;

public class SoundEventTimer {
	private Timer mSoundBufferTimer;

	public SoundEventTimer() {
		mSoundBufferTimer = new Timer( WaveSoundBufferNI.SB_BEAT_INTERVAL, new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				WaveSoundBufferNI.doSoundEvents();
			}
		});
	}
	protected void finalize() {
		if( mSoundBufferTimer.isRunning() ) mSoundBufferTimer.stop();
		try {
			super.finalize();
		} catch (Throwable e) {
		}
	}
	public void startIfStop() {
		if( mSoundBufferTimer.isRunning() == false ) {
			mSoundBufferTimer.start();
		}
	}
	public void stop() {
		mSoundBufferTimer.stop();
	}
}
