package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.BinaryOutputStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.env.Font;
import jp.kirikiri.tvp2.env.NativeImageBuffer;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public class BaseBitmap {
	public final static int BB_COPY_MAIN = 1;
	public final static int BB_COPY_MASK = 2;

	private NativeImageBuffer mBitmap;
	private boolean mFontChanged;

	private Font mFont;
	//private PrerenderedFont mPrerenderedFont; // プリレンダリング済みフォント

	/*
	private int mGlobalFontState;
	// v--- these can be recreated in ApplyFont if FontChanged flag is set
	private int mAscentOfsX;
	private int mAscentOfsY;
	private double mRadianAngle;
	private int mFontHash;

	*/
	private int mTextWidth;
	private int mTextHeight;
	private String mCachedText;

	public BaseBitmap(int w, int h, int bpp) {
		// TVPFontDCAddRef();

		mFont = Font.getDefaultFont();
		// mPrerenderedFont = null;
		mFontChanged = true;
		//mGlobalFontState = -1;

		//mTextWidth = mTextHeight = 0;

		mBitmap = new NativeImageBuffer(w,h);
	}

	public BaseBitmap(BaseBitmap r) {

		mFont = Font.getDefaultFont();
		// mPrerenderedFont = null;
		// mLogFont = TVPDefaultLOGFONT;
		mFontChanged = true;
		//mGlobalFontState = -1;

		//mTextWidth = mTextHeight = 0;

		mBitmap = r.mBitmap;
		mBitmap.addRef();
	}

	@Override
	protected final void finalize() {
		if( mBitmap != null ) {
			mBitmap.release();
			mBitmap = null;
		}
		try {
			super.finalize();
		} catch (Throwable e) {
		}
	}

	public final int getWidth() { return mBitmap.getWidth(); }
	private final void setWidth( int w ) throws TJSException { setSize( w, getHeight() ); }

	public final int getHeight() { return mBitmap.getHeight(); }
	private final void setHeight( int h ) throws TJSException { setSize( getWidth(), h ); }

	public final void setSize(int w, int h ) throws TJSException { setSize( w, h, true ); }
	public final void setSize(int w, int h, boolean keepimage ) throws TJSException {
		if (mBitmap.getWidth() != w || mBitmap.getHeight() != h ) {
			NativeImageBuffer newbitmap;
			if( keepimage ) {
				/*
				int lh = h < mBitmap.getHeight() ? h : mBitmap.getHeight();
				int lw = w < mBitmap.getWidth() ? w : mBitmap.getWidth();
				newbitmap.copyRect(0, 0, mBitmap, new Rect(0,0,lw,lh) );
				*/
				newbitmap = new NativeImageBuffer( w, h, mBitmap );
			} else {
				newbitmap = new NativeImageBuffer( w, h, mBitmap.getBPP() );
			}
			mBitmap.release();
			mBitmap = null;
			mBitmap = newbitmap;
			mFontChanged = true;
		}
	}

	/** bits per pixel を取得する */
	public final int getBPP() { return mBitmap.getBPP(); }
	/** 32bppかどうか確認する */
	public final boolean is32BPP() { return getBPP() == 32; }
	/** 8bppかどうか確認する */
	public final boolean is8BPP() { return getBPP() == 8; }

	/**
	 * 指定 bitmap / font をこのクラスに適用する
	 * @param rhs 適用元画像/フォント保持クラス
	 * @return 適用したかどうか
	 */
	public boolean assign( final BaseBitmap rhs) {
		if( this == rhs || mBitmap == rhs.mBitmap ) return false;

		mBitmap.release();
		mBitmap = null;
		mBitmap = rhs.mBitmap;
		mBitmap.addRef();

		mFont = rhs.mFont;
		mFontChanged = true;
		return true;
	}
	/**
	 * 画像のみをこのクラスに適用する
	 * @param rhs 適用元画像保持クラス
	 * @return 適用したかどうか
	 */
	public boolean assignBitmap( final BaseBitmap rhs) {
		if( this == rhs || mBitmap == rhs.mBitmap ) return false;

		mBitmap.release();
		mBitmap = null;
		mBitmap = rhs.mBitmap;
		mBitmap.addRef();
		mFontChanged = true;
		return true;
	}

	public boolean setNativeBitmap( final NativeImageBuffer rhs ) {
		if( mBitmap == rhs ) return false;

		mBitmap.release();
		mBitmap = null;
		mBitmap = rhs;
		mFontChanged = true;
		return true;
	}

	/** スキャンラインの取得(現状正しく機能しない) */
	public void getScanLine( int l, int[] buff) { mBitmap.getScanLine(l,buff); }
	/** スキャンラインの取得(現状正しく機能しない) */
	public int[] getScanLine( int l ) { return mBitmap.getScanLine(l); }
	/** 書き込み可能スキャンラインの取得(現状正しく機能しない) */
	public void getScanLineForWrite( int l, int[] buff) { independ(); mBitmap.getScanLine(l, buff); }
	/** ピッチを取得する(現状幅を返すのみ) */
	public int getPitchBytes() { return getWidth(); }

	/** 他と画像共有している時は、分離し独立する。共有元の画像もコピーする */
	public void independ() {
		if( mBitmap.isIndependent() ) return;

		NativeImageBuffer newb = new NativeImageBuffer(mBitmap);
		mBitmap.release();
		mBitmap = null;
		mBitmap = newb;
		mFontChanged = true; // informs internal font information is invalidated
	}

	/** 他と画像共有している時は、分離し独立する。共有元の画像はコピーしない */
	public void independNoCopy() {
		if(mBitmap.isIndependent()) return;
		recreate();
	}

	/** 画像を再生成する */
	private void recreate() {
		recreate( mBitmap.getWidth(), mBitmap.getHeight(), mBitmap.getBPP() );
	}

	/** 画像を再生成する */
	private void recreate(int width, int height, int bpp) {
		mBitmap.release();
		mBitmap = null;
		mBitmap = new NativeImageBuffer(width, height, bpp);
		mFontChanged = true; // informs internal font information is invalidated
	}

	private void applyFont() {
		// apply font
		if( mFontChanged ) { //|| mGlobalFontState != TVPGlobalFontStateMagic)
			independ();
			mFontChanged = false;
			//GlobalFontState = TVPGlobalFontStateMagic;
			//CachedText.Clear();
			mTextWidth = mTextHeight = 0;

			//if(mPrerenderedFont!=null) PrerenderedFont->Release();
			//mPrerenderedFont = TVPGetPrerenderedMappedFont(mFont);

			mFont = new Font(mFont);
			/*
			int ascent = TVPFontDCGetAscentHeight();
			mRadianAngle = Font.Angle * (M_PI/1800);
			double angle90 = mRadianAngle + Math.PI_2;
			mAscentOfsX = -Math.cos(angle90) * ascent;
			mAscentOfsY = Math.sin(angle90) * ascent;
			*/
		} else {
			// TVPFontDCApplyFont(this, false);
		}
	}
	/**
	 * 画像を他と共有していないかどうか確認する
	 * @return true : 共有していない, false : 共有している
	 */
	public boolean isIndependent() { return mBitmap.isIndependent(); }

	/** ネイティブ画像クラスを返す */
	public NativeImageBuffer getNativeImageBuffer() { return mBitmap; }
	/** ネイティブ画像クラスを返す */
	public NativeImageBuffer getBitmap() { return mBitmap; }

	/** フォントを指定する */
	public void setFont(Font font) {
		mFont = font;
		mFontChanged = true;
	}
	/** 設定されているフォントを取得する */
	public Font getFont() { applyFont(); return mFont; }

	/**
	 * フォント選択ダイアログを表示して、フォントを選択する
	 * @param flags
	 * @param caption ダイアログボックスのキャプション ( タイトルバー ) に表示する文字列
	 * @param prompt ダイアログボックス内に表示するメッセージ
	 * @param samplestring ダイアログボックス内の「サンプル」の部分に表示する文字列を指定
	 * @param faceName 初期選択フェイス名
	 * @return ユーザが OK ボタンを選択した場合は true、それ以外の場合は false
	 */
	public boolean selectFont(int flags, String caption, String prompt, String samplestring, String faceName) {
		// TODO 自動生成されたメソッド・スタブ
		applyFont();
		return false;
	}
	/**
	 * フォント一覧を取得する
	 * @param flags フォントの種類制限フラグ
	 * @param list フォント一覧格納先
	 */
	public void getFontList(int flags, ArrayList<String> list) { Font.getFontList( flags, list ); }


	public void mapPrerenderedFont(String storage) {
		// TODO 自動生成されたメソッド・スタブ
		applyFont();
	}

	public void unmapPrerenderedFont() {
		//DebugClass.addLog("unmapPrerenderedFont");
		// TODO 自動生成されたメソッド・スタブ
		applyFont();
	}

	/**
	 * 文字列の描画
	 * @param destrect
	 * @param x
	 * @param y
	 * @param text
	 * @param color
	 * @param bltmode
	 * @param opa
	 * @param holdalpha
	 * @param aa
	 * @param shlevel
	 * @param shadowcolor
	 * @param shwidth
	 * @param shofsx
	 * @param shofsy
	 * @param updaterects
	 */
	public final void drawText( final Rect destrect, int x, int y, final String text,
			int color, int bltmode, int opa, boolean holdalpha, boolean aa,
			int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects ) {
		independ();
		applyFont();
		mBitmap.drawText( mFont, destrect, x, y, text, color, bltmode, opa, holdalpha, aa, shlevel, shadowcolor, shwidth, shofsx, shofsy, updaterects);
	}

	/**
	 * テキストのサイズ取得
	 * @param text 取得したい文字列
	 */
	private void getTextSize( String text ) {
		applyFont();
		if( mCachedText == null || mCachedText.equals(text) != true ) {
			mCachedText = text;
			Size size = mFont.getTextSize(text);
			mTextWidth = size.width;
			mTextHeight = size.height;
		}
	}
	/**
	 * テキストの幅取得
	 * @param text 取得したい文字列
	 * @return 幅
	 */
	public int getTextWidth(String text) {
		getTextSize(text);
		return mTextWidth;
	}
	/**
	 * テキストの高さ取得
	 * @param text 取得したい文字列
	 * @return 高さ
	 */
	public int getTextHeight(String text) {
		getTextSize(text);
		return mTextHeight;
	}

	/**
	 * 文字の横方向への X 座標の移動量
	 * @param text 取得したい文字列
	 * @return
	 */
	public double getEscWidthX(String text) {
		getTextSize(text);
		return Math.cos(mFont.getAngle()) * mTextWidth;
	}

	/**
	 * 文字の横方向への Y 座標の移動量
	 * @param text
	 * @return
	 */
	public double getEscWidthY(String text) {
		getTextSize(text);
		return Math.sin(mFont.getAngle()) * (-mTextWidth);
	}

	/**
	 * 文字の縦方向への X 座標の移動量
	 * @param text
	 * @return
	 */
	public double getEscHeightX(String text) {
		getTextSize(text);
		return Math.sin(mFont.getAngle()) * mTextHeight;
	}

	/**
	 * 文字の縦方向への Y 座標の移動量
	 * @param text
	 * @return
	 */
	public double getEscHeightY(String text) {
		getTextSize(text);
		return Math.cos(mFont.getAngle()) * mTextHeight;
	}

	public void setSizeWithFill(int w, int h, int fillvalue) throws TJSException {
		//DebugClass.addLog("setSizeWithFill");
		// resize, and fill the expanded region with specified value.
		int orgw = getWidth();
		int orgh = getHeight();

		setSize(w, h);

		if(w > orgw && h > orgh) {
			// both width and height were expanded
			Rect rect = new Rect();
			rect.left = orgw;
			rect.top = 0;
			rect.right = w;
			rect.bottom = h;
			fill(rect, fillvalue);

			rect.left = 0;
			rect.top = orgh;
			rect.right = orgw;
			rect.bottom = h;
			fill(rect, fillvalue);
		} else if(w > orgw) {
			// width was expanded
			Rect rect = new Rect();
			rect.left = orgw;
			rect.top = 0;
			rect.right = w;
			rect.bottom = h;
			fill(rect, fillvalue);
		} else if(h > orgh) {
			// height was expanded
			Rect rect = new Rect();
			rect.left = 0;
			rect.top = orgh;
			rect.right = w;
			rect.bottom = h;
			fill(rect, fillvalue);
		}
	}

	// 指定座標の色を返す
	public final int getPoint(int x, int y) throws TJSException {
		// get specified point's color or color index
		if( x < 0 || y < 0 || x >= getWidth() || y >= getHeight() )
			Message.throwExceptionMessage(Message.OutOfRectangle);
		return mBitmap.getPoint( x, y );
	}
	public final void setPoint(int x, int y, int n ) throws TJSException {
		// get specified point's color or color index
		if( x < 0 || y < 0 || x >= getWidth() || y >= getHeight() )
			Message.throwExceptionMessage(Message.OutOfRectangle);
		mBitmap.setPoint( x, y, n );
	}
	public boolean fill(Rect rect, int value) {
		//DebugClass.addLog("fill");
		independ();
		mBitmap.fill( rect, value );
		return true;
	}

	public boolean fillColor(Rect rect, int color, int opa ) throws TJSException {
		//DebugClass.addLog("fillColor");
		if(!is32BPP()) Message.throwExceptionMessage(Message.InvalidOperationFor8BPP);
		if( opa == 0 ) return false;
		if(opa < 0) opa = 0;
		if(opa > 255) opa = 255;

		independ();
		if( opa == 255 ) {
			// complete opaque fill
			mBitmap.fill( rect, color );
		} else {
			// alpha fill
			mBitmap.fillColor( rect, color, opa );
		}
		return true;
	}

	public boolean fillMask(Rect rect, int opa ) {
		//DebugClass.addLog("fillMask");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}
	public boolean fillMask(Rect destrect, boolean b) {
		//DebugClass.addLog("fillMask");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}
	/**
	 * copy bitmap rectangle.
	 * BB_COPY_MAIN in "plane" : main image is copied
	 * BB_COPY_MASK in "plane" : mask image is copied
	 * "plane" is ignored if the bitmap is 8bpp
	 * the source rectangle is ( "refrect" ) and the destination upper-left corner
	 * is (x, y).
	 *
	 * @param x
	 * @param y
	 * @param src
	 * @param refrect
	 * @param plane
	 * @return
	 */
	public boolean copyRect(int x, int y, BaseBitmap src, Rect refrect, int plane ) {
		//DebugClass.addLog("copyRect");
		// TODO planeを無視する仮版
		independ();
		return mBitmap.copyRect( x, y, src.getBitmap(), refrect );
	}
	public boolean copyRect(int x, int y, BaseBitmap ref, Rect refrect ) {
		//DebugClass.addLog("copyRect");
		//if(!Is32BPP()) plane = (TVP_BB_COPY_MASK|TVP_BB_COPY_MAIN);

		independ();
		if(x == 0 && y == 0 && refrect.left == 0 && refrect.top == 0 &&
			refrect.right == ref.getWidth() &&
			refrect.bottom == ref.getHeight() &&
			getWidth() == refrect.right &&
			getHeight() == refrect.bottom &&
			/*plane == (TVP_BB_COPY_MASK|TVP_BB_COPY_MAIN) &&*/
			!is32BPP() == !ref.is32BPP())
		{
			// entire area of both bitmaps
			assignBitmap(ref);
			return true;
		}

		// bound check
		int bmpw, bmph;

		bmpw = ref.getWidth();
		bmph = ref.getHeight();

		if(refrect.left < 0) {
			x -= refrect.left;
			refrect.left = 0;
		}
		if(refrect.right > bmpw)
			refrect.right = bmpw;

		if(refrect.left >= refrect.right) return false;

		if(refrect.top < 0) {
			y -= refrect.top;
			refrect.top = 0;
		}
		if(refrect.bottom > bmph)
			refrect.bottom = bmph;

		if(refrect.top >= refrect.bottom) return false;

		bmpw = getWidth();
		bmph = getHeight();

		Rect rect = new Rect();
		rect.left = x;
		rect.top = y;
		rect.right = rect.left + refrect.width();
		rect.bottom = rect.top + refrect.height();

		if(rect.left < 0) {
			refrect.left += -rect.left;
			rect.left = 0;
		}

		if(rect.right > bmpw) {
			refrect.right -= (rect.right - bmpw);
			rect.right = bmpw;
		}

		if(refrect.left >= refrect.right) return false; // not drawable

		if(rect.top < 0) {
			refrect.top += -rect.top;
			rect.top = 0;
		}

		if(rect.bottom > bmph) {
			refrect.bottom -= (rect.bottom - bmph);
			rect.bottom = bmph;
		}

		if(refrect.top >= refrect.bottom) return false; // not drawable

		return mBitmap.copyRect( rect.left, rect.top, ref.getBitmap(), refrect );
	}

	public void blt(int x, int y, BaseBitmap ref, Rect refrect, int method, int opa) throws TJSException {
		//DebugClass.addLog("blt");
		independ();
		blt(x, y, ref, refrect, method, opa, true);
	}
	public boolean blt(int x, int y, BaseBitmap ref, Rect refrect, int method, int opa, boolean hda) throws TJSException {
		//DebugClass.addLog("blt");
		// blt src bitmap with various methods.

		// hda option ( hold destination alpha ) holds distination alpha,
		// but will select more complex function ( and takes more time ) for it ( if
		// can do )

		// this function does not matter whether source and destination bitmap is
		// overlapped.

		independ();
		if(opa == 255 && method == LayerNI.bmCopy && !hda)
		{
			return copyRect(x, y, ref, refrect);
		}

		if(!is32BPP()) Message.throwExceptionMessage(Message.InvalidOperationFor8BPP);

		if(opa == 0) return false; // opacity==0 has no action

		// bound check
		int bmpw, bmph;

		bmpw = ref.getWidth();
		bmph = ref.getHeight();

		if(refrect.left < 0) {
			x -= refrect.left;
			refrect.left = 0;
		}
		if(refrect.right > bmpw)
			refrect.right = bmpw;

		if(refrect.left >= refrect.right) return false;

		if(refrect.top < 0) {
			y -= refrect.top;
			refrect.top = 0;
		}
		if(refrect.bottom > bmph)
			refrect.bottom = bmph;

		if(refrect.top >= refrect.bottom) return false;

		bmpw = getWidth();
		bmph = getHeight();


		Rect rect = new Rect();
		rect.left = x;
		rect.top = y;
		rect.right = rect.left + refrect.width();
		rect.bottom = rect.top + refrect.height();

		if(rect.left < 0)
		{
			refrect.left += -rect.left;
			rect.left = 0;
		}

		if(rect.right > bmpw)
		{
			refrect.right -= (rect.right - bmpw);
			rect.right = bmpw;
		}

		if(refrect.left >= refrect.right) return false; // not drawable

		if(rect.top < 0)
		{
			refrect.top += -rect.top;
			rect.top = 0;
		}

		if(rect.bottom > bmph)
		{
			refrect.bottom -= (rect.bottom - bmph);
			rect.bottom = bmph;
		}

		if(refrect.top >= refrect.bottom) return false; // not drawable

		return mBitmap.copyRect( rect, ref.getBitmap(), refrect, method, opa, hda );
	}

	public void saveAsBMP(String name, String type) throws TJSException {
		String nname = TVP.StorageMediaManager.normalizeStorageName(name,null);
		BinaryStream stream = Storage.createStream(nname,BinaryStream.WRITE);
		if( stream != null ) {
			BinaryOutputStream output = new BinaryOutputStream(stream);
			mBitmap.saveAs( output, name, type );
			output = null;
		}
		stream = null;
	}

	public void setPointMain(int x, int y, int actualColor) {
		//DebugClass.addLog("setPointMain");
		// TODO 自動生成されたメソッド・スタブ

	}

	public void setPointMask(int x, int y, int mask) {
		//DebugClass.addLog("setPointMask");
		// TODO 自動生成されたメソッド・スタブ

	}



	public boolean fillColorOnAlpha(Rect destrect, int color, int opa) {
		//DebugClass.addLog("fillColorOnAlpha");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean removeConstOpacity(Rect destrect, int i) {
		//DebugClass.addLog("removeConstOpacity");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean fillColorOnAddAlpha(Rect destrect, int color, int opa) {
		//DebugClass.addLog("fillColorOnAddAlpha");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean stretchBlt(Rect mClipRect, Rect destrect,
			BaseBitmap mMainImage, Rect srcrect, int bmcopy, int i,
			boolean mHoldAlpha, int type) {
		//DebugClass.addLog("stretchBlt");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean affineBlt(Rect mClipRect, BaseBitmap mMainImage,
			Rect srcrect, AffineMatrix2D matrix, int bmcopy, int i,
			Rect updaterect, boolean b, int type, boolean clear,
			int mNeutralColor) {
		//DebugClass.addLog("affineBlt");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean affineBlt(Rect mClipRect, BaseBitmap mMainImage,
			Rect srcrect, PointD[] points, int bmcopy, int i, Rect updaterect,
			boolean b, int type, boolean clear, int mNeutralColor) {
		//DebugClass.addLog("affineBlt");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean affineBlt(Rect mClipRect, BaseBitmap mMainImage,
			Rect srcrect, AffineMatrix2D matrix, int bmalphaonalpha,
			int opacity, Rect updaterect, boolean mHoldAlpha, int type) {
		//DebugClass.addLog("affineBlt");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean affineBlt(Rect mClipRect, BaseBitmap mMainImage,
			Rect srcrect, PointD[] points, int bmalphaonalpha, int opacity,
			Rect updaterect, boolean mHoldAlpha, int type) {
		//DebugClass.addLog("affineBlt");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean doBoxBlur(Rect mClipRect, Rect rect) {
		//DebugClass.addLog("doBoxBlur");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public boolean doBoxBlurForAlpha(Rect mClipRect, Rect rect) {
		//DebugClass.addLog("doBoxBlurForAlpha");
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	public void adjustGammaForAdditiveAlpha(Rect mClipRect, GammaAdjustData data) {
		//DebugClass.addLog("adjustGammaForAdditiveAlpha");
		// TODO 自動生成されたメソッド・スタブ

	}

	public void adjustGamma(Rect mClipRect, GammaAdjustData data) {
		//DebugClass.addLog("adjustGamma");
		// TODO 自動生成されたメソッド・スタブ

	}

	public void doGrayScale(Rect mClipRect) {
		//DebugClass.addLog("doGrayScale");
		// TODO 自動生成されたメソッド・スタブ

	}

	public void flipLR(Rect rect) throws TJSException {
		if(rect.left < 0 || rect.top < 0 || rect.right > getWidth() || rect.bottom > getHeight())
			Message.throwExceptionMessage(Message.SrcRectOutOfBitmap);

		independ();
		mBitmap.flipLR(rect);
	}

	public void flipUD(Rect rect) throws TJSException {
		if(rect.left < 0 || rect.top < 0 || rect.right > getWidth() || rect.bottom > getHeight())
			Message.throwExceptionMessage(Message.SrcRectOutOfBitmap);

		independ();
		mBitmap.flipUD(rect);
	}

	public void convertAddAlphaToAlpha() {
		if( mBitmap.isAlphaPremultiplied() == true ) {
			independ();
			mBitmap.coerceData(false);
		}
	}

	public void convertAlphaToAddAlpha() {
		if( mBitmap.isAlphaPremultiplied() == false ) {
			independ();
			mBitmap.coerceData(true);
		}
	}


}
