package jp.kirikiri.tvp2.env;

import java.lang.reflect.InvocationTargetException;

import javax.swing.SwingUtilities;

import jp.kirikiri.tvp2.TVP;

public class EventHandleThread extends Thread {

	public EventHandleThread() {
		super();
		setName("TVP Event Handle Thread");
	}
	@Override
	public void run() {
		while( true ) {
			long tick = System.currentTimeMillis();
			try {
				SwingUtilities.invokeAndWait(new Runnable() {
					public void run() {
						// 定期的にイベントを突っ込む
						TVP.MainForm.applicationIdle();
						/*
						try {
							TVP.MainWindow.repaint();
						} catch (VariantException e) {
						} catch (TJSException e) {
						}
						*/
					}
				});
			} catch (InterruptedException e1) {
			} catch (InvocationTargetException e1) {
			}
			long end = System.currentTimeMillis();
			long waitTime = 16 - (end - tick);
			if( waitTime > 0 ) {
				try {
					Thread.sleep(waitTime);
				} catch (InterruptedException e) {
				}
			}
		}
	}
}
