package jp.kirikiri.tjs2;


abstract class NativeFunction extends Dispatch {
	private static final int S_TRUE = 1;

	public NativeFunction() {
		this(null);
	}

	// 'name' is just to be used as a label for debugging
	public NativeFunction( String name ) {
		super();
	}

	public int funcCall( int flag, final String membername, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) {
			return super.funcCall( flag, membername, result, param, objthis );
		}
		return process( result, param, objthis );
	}

	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Function".equals( classname ) ) return S_TRUE;
		}
		return super.isInstanceOf( flag, membername, classname, objthis );
	}

	// override this instead of FuncCall
	abstract protected int process( Variant result, Variant[] param, Dispatch2 objthis );
}

