/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.utils;

import java.util.HashMap;

import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;

public class ScnearioCache {

	class ClearScenarioCacheCallback implements CompactEventCallbackInterface {
		public void onCompact( int level ) {
			if(level >= CompactEventCallbackInterface.COMPACT_LEVEL_DEACTIVATE) {
				// clear the scenario cache
				clearScnearioCache();
			}
		}
	}

	private HashMap<String,ScenarioCacheItem> mScenarioCache;
	private ClearScenarioCacheCallback mCallback;
	private boolean mClearScenarioCacheCallbackInit = false;

	public ScnearioCache() {
		mScenarioCache = new HashMap<String,ScenarioCacheItem>();
	}

	public void clearScnearioCache() {
		mScenarioCache.clear();
	}

	public ScenarioCacheItem getScenario( final String storagename, boolean isstring ) {
		// compact interface initialization
		if(!mClearScenarioCacheCallbackInit) {
			mCallback = new ClearScenarioCacheCallback();
			TVP.EventManager.addCompactEventHook(mCallback);
			mClearScenarioCacheCallbackInit = true;
		}

		if(isstring) {
			// we do not cache when the string is passed as a scenario
			return new ScenarioCacheItem(storagename, true);
		}

		// make hash and search over cache
		ScenarioCacheItem ptr = mScenarioCache.get(storagename);
		if( ptr != null ) {
			// found in the cache
			return ptr;
		}

		// not found in the cache
		ScenarioCacheItem item = new ScenarioCacheItem(storagename, false);
		// push into scenario cache hash
		mScenarioCache.put(storagename, item );
		return item;
	}
}
