/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.SystemInitializer;

public class LogStreamHolder {

	PrintWriter mStream;
	boolean mAlive;
	boolean mOpenFailed;

	public LogStreamHolder() {
		//mStream = null;
		mAlive = true;
		//mOpenFailed = false;
	}

	protected void finalize() {
		if(mStream!=null){
			mStream.close();
		}
		mAlive = false;
	}
	 private static boolean checkBeforeWritefile(File file){
		  if( file.exists() ){
			  if( file.isFile() && file.canWrite() ){
				  return true;
			  }
			  return false;
		  }
		  return true;
	}
	private static final String SEPARATOR = "\n\n\n==============================================================================\n==============================================================================\n";
	private void open( boolean append ) {
		if(mOpenFailed) return; // no more try

		try {
			String filename = null;
			if( TVP.DebugLog.enableLogLoacation() == false) {
				mStream = null;
				mOpenFailed = true;
			} else {
				// no log location specified
				filename = TVP.DebugLog.getNativeLogLocation() + "\\krkr.console.log";
				SystemInitializer.ensureDataPathDirectory();

				File file = new File(filename);

				if( checkBeforeWritefile(file) ) {
					boolean appendbom = file.exists() == false;
					mStream = new PrintWriter(new BufferedWriter(new FileWriter(file,append)));
					if( mStream != null && appendbom ) {
						mStream.write(0xff);
						mStream.write(0xfe);
					}
				}
				if(mStream==null) mOpenFailed = true;
			}

			if(mStream!=null) {
				log(SEPARATOR);

				Calendar cal = Calendar.getInstance();
				Date date = cal.getTime();
				DateFormat formatter = DateFormat.getDateInstance();
				String timebuf = formatter.format(date);
				formatter = null;
				date = null;
				cal = null;

				StringBuffer buffer = new StringBuffer(32);
				buffer.append("Logging to ");
				buffer.append( filename );
				buffer.append(" started on ");
				buffer.append( timebuf );
				log( buffer.toString() );
				buffer = null;

			}
		} catch( IOException e ) {
			mOpenFailed = true;
		}
	}

	/**
	 * clear log text
	 */
	public void clear() {
		if( mStream != null ) mStream.close();
		open( false );
	}
	public void log( final String text ) {
		if(mStream==null) open(true);

		if(mStream!=null) {
			mStream.print(text);
			mStream.print('\n');
			mStream.flush();
		}
	}

	/**
	 * reopen log stream
	 */
	public void reopen() {
		if(mStream!=null) mStream.close();
		mStream = null;
		mAlive = false;
		mOpenFailed = false;
	}
}
