/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Interface;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.msg.Message;

public class DebugClass extends NativeClass {

	static int mClassID = -1;
	static private final String CLASS_NAME = "Debug";

	public static void addLog( String mes ) {
		TVP.DebugLog.addLog( mes );
	}
	public static void addImportantLog( String mes ) {
		TVP.DebugLog.addImportantLog( mes );
	}

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public DebugClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, TVP.ReturnOKConstructor, CLASS_NAME, Interface.nitMethod, 0 );

		registerNCM( "finalize", TVP.ReturnOKMethod, CLASS_NAME, Interface.nitMethod, 0 );

		registerNCM( "message", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return Error.E_BADPARAMCOUNT;
				if( param.length == 1 ) {
					addLog( param[0].asString() );
				} else {
					// display the arguments separated with ", "
					StringBuilder builder = new StringBuilder(512);
					for( int i = 0; i < param.length; i++ ) {
						if( i != 0 ) builder.append(", ");
						builder.append( param[i].asString() );
					}
					addLog( builder.toString() );
				}
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "notice", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return Error.E_BADPARAMCOUNT;
				if( param.length == 1 ) {
					addImportantLog( param[0].asString() );
				} else {
					// display the arguments separated with ", "
					StringBuilder builder = new StringBuilder(512);
					for( int i = 0; i < param.length; i++ ) {
						if( i != 0 ) builder.append(", ");
						builder.append( param[i].asString() );
					}
					addImportantLog( builder.toString() );
				}
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "startLogToFile", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				boolean clear = false;
				if( param.length >= 1) clear = param[0].asBoolean();
				TVP.DebugLog.startLogToFile(clear);
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		registerNCM( "logAsError", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				TVP.DebugLog.onError();
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, Interface.STATICMEMBER );

		// property
		registerNCM( "logLocation", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getLogLocation() );
				return Error.S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException, TJSException {
				TVP.DebugLog.setLogLocation( param.asString() );
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitProperty, Interface.STATICMEMBER );

		registerNCM( "logToFileOnError", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getAutoLogToFileOnError() ? 1 : 0 );
				return Error.S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.DebugLog.setAutoLogToFileOnError( param.asBoolean() );
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitProperty, Interface.STATICMEMBER );

		registerNCM( "clearLogFileOnError", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getAutoClearLogOnError() ? 1 : 0 );
				return Error.S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.DebugLog.setAutoClearLogOnError( param.asBoolean() );
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitProperty, Interface.STATICMEMBER );

		registerNCM( "controller", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				Dispatch2 dsp = TVP.getControllerClass();
				result.set( dsp, dsp );
				return Error.S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return Error.E_ACCESSDENYED; }
		}, CLASS_NAME, Interface.nitProperty, Interface.STATICMEMBER );

		registerNCM( "console", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				Dispatch2 dsp = TVP.getConsoleClass();
				result.set( dsp, dsp );
				return Error.S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return Error.E_ACCESSDENYED; }
		}, CLASS_NAME, Interface.nitProperty, Interface.STATICMEMBER );

		// put version information to DMS
		addImportantLog( TVP.Application.get().getVersionInformation() );
		addImportantLog( Message.VersionInformation2  );
	}

}
