package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;

public class SimpleOptionProviderObject implements SimpleOptionProvider {

	private VariantClosure mObject;
	//private String mString;
	private Variant mRetVariant;

	public SimpleOptionProviderObject( VariantClosure object ) {
		mObject = object;
		mRetVariant = new Variant();
	}
	@Override
	public int getAsNumber(String name, long[] value) {
		try {
			mRetVariant.clear();
			int er = mObject.propGet( 0, name, mRetVariant, null );
			if( er < 0 ) return er;

			if( mRetVariant.isVoid() ) return Error.E_MEMBERNOTFOUND;

			if( value != null ) value[0] = mRetVariant.asInteger();
			mRetVariant.clear();

			return Error.S_OK;
		} catch( TJSException e ) {
			return Error.E_FAIL;
		}
	}

	@Override
	public int getAsString(String name, String[] out) {
		try {
			mRetVariant.clear();
			int er = mObject.propGet( 0, name, mRetVariant, null );
			if( er < 0 ) return er;

			if( mRetVariant.isVoid() ) return Error.E_MEMBERNOTFOUND;

			if( out != null ) out[0] = mRetVariant.asString();
			mRetVariant.clear();

			return Error.S_OK;
		} catch( TJSException e ) {
			return Error.E_FAIL;
		}
	}

	@Override
	public int getValue(String name, Variant dest) {
		try {
			if( dest == null ) return Error.E_FAIL;
			int er = mObject.propGet( 0, name, dest, null );
			if( er < 0 ) return er;
			return Error.S_OK;
		} catch( TJSException e ) {
			return Error.E_FAIL;
		}
	}

	@Override
	public int getDispatchObject(Holder<Dispatch2> dsp) {
		if( dsp != null ) dsp.mValue = mObject.mObjThis;
		return Error.S_OK;
	}

}
