package jp.kirikiri.tjs2;

import java.util.ArrayList;

public class ExprNode {

	private int mOp;
	private int mPosition;
	private ArrayList<ExprNode> mNodes;
	private Variant mVal;

	public ExprNode() {
		//mOp = 0;
		//mNodes = null;
		//mVal = null;
		mPosition = -1;
	}
	protected void finalize() {
		if( mNodes != null ) {
			final int count = mNodes.size();
			for( int i = 0; i < count; i++ ) {
				ExprNode node = mNodes.get(i);
				if( node != null ) node.clear();
			}
			mNodes.clear();
			mNodes = null;
		}
		if( mVal != null ) {
			mVal.clear();
			mVal = null;
		}
	}

	public final void setOpecode( int op ) { mOp = op; }
	public final void setPosition( int pos ) { mPosition = pos; }
	public final void setValue( Variant val ) {
		if( mVal == null ) {
			mVal = new Variant(val);
		} else {
			mVal.copyRef( val );
		}
	}
	public final void add( ExprNode node ) {
		if( mNodes == null ) mNodes = new ArrayList<ExprNode>();
		mNodes.add( node );
	}

	public final int getOpecode() { return mOp; }
	public final int getPosition() { return mPosition; }
	public final Variant getValue() { return mVal; }
	public final ExprNode getNode( int index ) {
		if( mNodes == null ) {
			return null;
		} else if( index < mNodes.size() ) {
			return mNodes.get( index );
		} else {
			return null;
		}
	}
	public final int getSize() {
		if( mNodes == null ) return 0;
		else return mNodes.size();
	}
	public final void addArrayElement( Variant val ) throws TJSException, VariantException {
		final String ss_add = "add";
		Variant[] args = new Variant[1];
		args[0] = val;
		mVal.asObjectClosure().funcCall(0, ss_add, null, args, null );
	}
	public final void addDictionaryElement( String name, Variant val ) throws TJSException, VariantException {
		mVal.asObjectClosure().propSet(Interface.MEMBERENSURE, name, val, null);
	}

	public final void clear() {
		if( mNodes != null ) {
			final int count = mNodes.size();
			for( int i = 0; i < count; i++ ) {
				ExprNode node = mNodes.get(i);
				if( node != null ) node.clear();
			}
			mNodes.clear();
			mNodes = null;
		}
		if( mVal != null ) {
			mVal.clear();
			mVal = null;
		}
	}
}
