package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;


public interface StorageMedia {

	/**
	 * returns media name like "file", "http" etc.
	 */
	public String getName();

	/**
	 * normalize domain name according with the media's rule
	 */
	public String normalizeDomainName( final String name );

	/**
	 * normalize path name according with the media's rule
	 * "name" below is normalized but does not contain media, eg.
	 * not "media://domain/path" but "domain/path"
	 */
	public String normalizePathName( final String name );

	public String getDefaultDomain();

	/**
	 * check file existence
	 * @throws TJSException
	 */
	public boolean checkExistentStorage( final String name ) throws TJSException;

	/**
	 * open a storage and return a tTJSBinaryStream instance.
	 * name does not contain in-archive storage name but
	 * is normalized.
	 * @throws TJSException
	 */
	public BinaryStream open( final String name, int flags ) throws TJSException;

	/**
	 * list files at given place
	 * @throws TJSException
	 */
	public void getListAt( final String name, StorageLister lister ) throws TJSException;

	/**
	 * basically the same as above,
	 * check wether given name is easily accessible from local OS filesystem.
	 * if true, returns local OS native name. otherwise returns an empty string.
	 */
	public String getLocallyAccessibleName( String name );
}
