package jp.kirikiri.tvp2.visual;

/**
 * Structure for monitor screen mode candidate
 */
public class ScreenModeCandidate extends ScreenMode {
	public int mZoomNumer; // zoom ratio numer
	public int mZoomDenom; // zoom ratio denom
	public int mRankZoomIn;
	public int mRankBPP;
	public int mRankZoomBeauty;
	public int mRankSize; // candidate preference priority (lower value is higher preference)

	public String dump() {
		StringBuilder builder = new StringBuilder(128);
		builder.append(super.dump());
		builder.append(", ZoomNumer=");
		builder.append(mZoomNumer);
		builder.append(", ZoomDenom=");
		builder.append(mZoomDenom);
		builder.append(", RankZoomIn=");
		builder.append(mRankZoomIn);
		builder.append(", RankBPP=");
		builder.append(mRankBPP);
		builder.append(", RankZoomBeauty=");
		builder.append(mRankZoomBeauty);
		builder.append(", RankSize=");
		builder.append(mRankSize);
		return builder.toString();
	}

	// operator <
	public boolean littlerThan( final ScreenModeCandidate rhs ) {
		if(mRankZoomIn < rhs.mRankZoomIn) return true;
		if(mRankZoomIn > rhs.mRankZoomIn) return false;
		if(mRankBPP < rhs.mRankBPP) return true;
		if(mRankBPP > rhs.mRankBPP) return false;
		if(mRankZoomBeauty < rhs.mRankZoomBeauty) return true;
		if(mRankZoomBeauty > rhs.mRankZoomBeauty) return false;
		if(mRankSize < rhs.mRankSize) return true;
		if(mRankSize > rhs.mRankSize) return false;
		return false;
	}
}
