package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.env.NativeImageBuffer;

public interface ScanLineProvider {
	/**
	 * @return width image width
	 */
	public int getWidth();

	/**
	 *
	 * @return height image height
	 */
	public int getHeight();

	/**
	 *
	 * @return bpp image bit depth
	 */
	public int getPixelFormat();

	/**
	 *
	 * @return pitch image bitmap data width in bytes ( offset to next down line )
	 */
	public int getPitchBytes();

	/**
	 *
	 * @return
	 */
	public NativeImageBuffer getScanLine();

	/**
	 *
	 * @return
	 */
	public NativeImageBuffer getScanLineForWrite();

	/**
	 * src のデータをそのまま自分にコピー
	 * @param src
	 * @throws TJSException
	 */
	public void copyFrom( ScanLineProvider src ) throws TJSException;
}
