package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

public class RegionRect extends Rect {

	/*
	class RegionRectInitialHolder {
		// Initial rectangle holder to prevent unnecessary freeing of the vector.
		// This holds a rectangle from program start to end.
		private RegionRect InitialRect;
		public RegionRectInitialHolder() { InitialRect = null; }
		void hold() {
			if( InitialRect == null ) {
				//InitialRect = (tTVPRegionRect *)-1;
				InitialRect = allocate();
			}
		}
		protected void finalize() {
			if(InitialRect != null ) release(InitialRect);
		}
	}
	static RegionRectInitialHolder RegionRectInitialHolder;
	*/

	static private ArrayList<RegionRect> RegionFreeRects;
	static private final int REGIONRECT_ALLOC_UNITS = 256;
	static private int RegionFreeMaxCount = 0;

	static private void prepareRegionRectangle() {
		// Prepare rectangles and insert them into free rectangle list
		for( int i = 0; i < REGIONRECT_ALLOC_UNITS; i++ ) {
			RegionFreeRects.add( new RegionRect() );
			RegionFreeMaxCount++;
		}
	}
	static public void initialize() {
		RegionFreeRects = new ArrayList<RegionRect>(REGIONRECT_ALLOC_UNITS*2);
		prepareRegionRectangle();
	}
	public static void finalizeApplication() {
		RegionFreeRects = null;
	}

	// TODO どうもプールするとfinalizeで呼ばれるケースでバグるっぽい
	static public RegionRect allocate() {
		// Allocate a region rectangle. Note that this function does not clear
		// nor initialize the rectangle object.

		// Create a vector of free rectangle list if it does not exists
		//if( RegionFreeRects == null )
		//	RegionFreeRects = new ArrayList<RegionRect>(REGIONRECT_ALLOC_UNITS*2);

		// Prepare free rectangles if the free list is empty
		//if( RegionFreeRects.size() == 0 )
		//	prepareRegionRectangle();

		// Take a free rectangle from last of the free rectangle list
		final int last = RegionFreeRects.size()-1;
		if( last < 0 ) return new RegionRect();

		RegionRect r = RegionFreeRects.get(last);
		RegionFreeRects.remove(last);

		// Hold initial rectangle
		// RegionRectInitialHolder.Hold();

		// Return the rectangle
		return r;
	}
	static public void release( RegionRect rect) {
		// Deallocate a region rectangle allocated in TVPAllocateRegionRect().

		// 多くなりすぎた時はそのまま放置
		if( RegionFreeRects.size() > (REGIONRECT_ALLOC_UNITS*2) )
			return;

		// Append to TVPRegionFreeRects
		RegionFreeRects.add(rect);

		// Full-Free check
		/*
		if( RegionFreeRects.size() == RegionFreeMaxCount ) {
			// Free all rectangles
			// Free the vector
			RegionFreeRects.clear();
			RegionFreeRects = null;
			RegionFreeMaxCount = 0;
		}
		*/
	}

	public RegionRect Prev; // previous link
	public RegionRect Next; // next link

	public RegionRect() {}
	public RegionRect( final Rect r) { super(r); }

	// link operations
	public void linkAfter( RegionRect r ) {
		// Insert this after r.
		RegionRect n = r.Next;
		r.Next = this;
		n.Prev = this;
		Prev = r;
		Next = n;
	}

	public void linkBefore( RegionRect r ) {
		// Insert this before r.
		RegionRect p = r.Prev;
		r.Prev = this;
		p.Next = this;
		Prev = p;
		Next = r;
	}

	public void unlink() {
		// unchain from the link list
		RegionRect prev = Prev;
		RegionRect next = Next;
		prev.Next = next;
		next.Prev = prev;
	}
}
