package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tvp2.env.Font;

public class FontInfomation {
	private String mFaceName;
	private int mHeight;
	private int mFlags;
	private int mAngle;

	public FontInfomation() {}
	public FontInfomation( final String face, int height, int flags, int angle ) {
		mFaceName = face;
		mHeight = height;
		mFlags = flags;
		mAngle = angle;
	}
	public FontInfomation( Font f ) {
		mFaceName = f.getFaceName();
		mHeight = f.getHeight();
		mAngle = f.getAngle();
		mFlags = 0;
		mFlags |= f.getBold() ? Font.TF_BOLD : 0;
		mFlags |= f.getItalic() ? Font.TF_ITALIC : 0;
		mFlags |= f.getStrikeout() ? Font.TF_STRIKEOUT : 0;
		mFlags |= f.getUnderline() ? Font.TF_UNDERLINE : 0;
	}
	public FontInfomation(FontInfomation font) {
		mFaceName = font.mFaceName;
		mHeight = font.mHeight;
		mFlags = font.mFlags;
		mAngle = font.mAngle;
	}
	public void setFont( Font f ) {
		mFaceName = f.getFaceName();
		mHeight = f.getHeight();
		mAngle = f.getAngle();
		mFlags = 0;
		mFlags |= f.getBold() ? Font.TF_BOLD : 0;
		mFlags |= f.getItalic() ? Font.TF_ITALIC : 0;
		mFlags |= f.getStrikeout() ? Font.TF_STRIKEOUT : 0;
		mFlags |= f.getUnderline() ? Font.TF_UNDERLINE : 0;
	}
	public boolean equals(Object o){
		if( o instanceof FontInfomation ) {
			FontInfomation f = (FontInfomation)o;
			if( mFaceName == null ) {
				if( mFaceName == f.mFaceName && mHeight == f.mHeight && mFlags == f.mFlags && mAngle == f.mAngle ) {
					return true;
				} else {
					return false;
				}
			} else if( mFaceName.equals( f.mFaceName) && mHeight == f.mHeight && mFlags == f.mFlags && mAngle == f.mAngle ) {
				return true;
			} else {
				return false;
			}
		} else {
			return false ;
		}
	}
	public int hashCode() {
		int hash = 0;
		if( mFaceName != null ) {
			hash = mFaceName.hashCode();
		}
		hash ^= mFlags;
		hash ^= mAngle;
		hash ^= mHeight;
		return hash;
	}
}
