package jp.kirikiri.tjs2;

public class TJSScriptError extends TJSException {

	/**
	 *
	 */
	private static final long serialVersionUID = -1727870605938357683L;

	private static final int  MAX_TRACE_TEXT_LEN = 1500;

	private SourceCodeAccessor mAccessor;
	private int mPosition;
	private String mTrace;


	public SourceCodeAccessor getAccessor() { return mAccessor; }

	public int getPosition() { return mPosition; }

	public int GetSourceLine() {
		return mAccessor.srcPosToLine(mPosition) +1;
	}

	public final String getBlockName() {
		final String name = mAccessor.getName();
		return name != null ? name : "";
	}

	public final String getTrace() { return mTrace; }

	public boolean addTrace( ScriptBlock block, int srcpos ) {
		int len = mTrace.length();
		if( len >= MAX_TRACE_TEXT_LEN) return false;

		if( len != 0 ) mTrace += " <-- ";
		mTrace += block.getLineDescriptionString(srcpos);
		return true;
	}
	public boolean addTrace( final String data ) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;
		if(len != 0) mTrace += " <-- ";
		mTrace += data;
		return true;
	}

	public TJSScriptError( final String Msg, SourceCodeAccessor accessor, int pos ) {
		super(Msg);
		mAccessor = accessor;
		mPosition = pos;
		mTrace = new String();
	}
	public TJSScriptError( final TJSScriptError ref) {
		mAccessor = ref.mAccessor;
		mPosition = ref.mPosition;
		mTrace = ref.mTrace;
	}

	public boolean addTrace(InterCodeObject context, int codepos) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;

		if(len != 0) mTrace += " <-- ";
		mTrace += context.getPositionDescriptionString(codepos);
		return true;
	}
}
