package jp.kirikiri.tvp2.utils;

import java.util.HashMap;

import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;

public class ScnearioCache {

	class ClearScenarioCacheCallback implements CompactEventCallbackInterface {
		public void onCompact( int level ) {
			if(level >= CompactEventCallbackInterface.COMPACT_LEVEL_DEACTIVATE) {
				// clear the scenario cache
				clearScnearioCache();
			}
		}
	}

	private HashMap<String,ScenarioCacheItem> mScenarioCache;
	private ClearScenarioCacheCallback mCallback;
	private boolean mClearScenarioCacheCallbackInit = false;

	public ScnearioCache() {
		mScenarioCache = new HashMap<String,ScenarioCacheItem>();
	}

	public void clearScnearioCache() {
		mScenarioCache.clear();
	}

	public ScenarioCacheItem getScenario( final String storagename, boolean isstring ) {
		// compact interface initialization
		if(!mClearScenarioCacheCallbackInit) {
			mCallback = new ClearScenarioCacheCallback();
			TVP.EventManager.addCompactEventHook(mCallback);
			mClearScenarioCacheCallbackInit = true;
		}

		if(isstring) {
			// we do not cache when the string is passed as a scenario
			return new ScenarioCacheItem(storagename, true);
		}

		// make hash and search over cache
		ScenarioCacheItem ptr = mScenarioCache.get(storagename);
		if( ptr != null ) {
			// found in the cache
			return ptr;
		}

		// not found in the cache
		ScenarioCacheItem item = new ScenarioCacheItem(storagename, false);
		// push into scenario cache hash
		mScenarioCache.put(storagename, item );
		return item;
	}
}
