package jp.kirikiri.tjs2;

/**
 * 最大格納数制限付きハッシュテーブル
 *
 * @param <Key> キー
 * @param <Value> 格納する値
 */
public class HashCache<Key,Value> extends HashTable<Key,Value> {

	/** 格納可能な最大要素数 */
	private int mMaxCount;

	/**
	 * コンストラクタ
	 * @param maxcount 格納可能な最大数
	 */
	public HashCache( int maxcount ) {
		mMaxCount = maxcount;
	}

	/**
	 * 要素の追加、最大数を超えた時は古いものが削除される
	 * @param key キー
	 * @param value 格納のする値
	 */
	@Override
	public void put( Key key, Value value ) {
		super.put( key, value );
		if( getCount() > mMaxCount ) {
			chopLast( getCount() - mMaxCount );
		}
	}
	/**
	 * 格納可能な数の設定
	 * @param maxcount 格納可能な数
	 */
	public void setMaxCount( int maxcount ) {
		mMaxCount = maxcount;
		if( getCount() > mMaxCount ) {
			chopLast( getCount() - mMaxCount );
		}
	}
	/**
	 * 格納可能な数を得る
	 * @return 格納可能な数
	 */
	public int getMaxCount() { return mMaxCount; }
}
