package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;

public interface SimpleImageProvider {

	/**
	 * load an image.
	 * returned image be an 8bpp bitmap when bpp == 8, otherwise 32bpp.
	 * key is a color key. pass 0x02ffffff for not to apply color key.
	 * you must release "scpro" when you done with it.
	 * w and h are desired size of the image. if the actual size is smaller
	 * than these, the image is to be tiled. give 0, 0 to obtain original
	 * sized image.
	 * @param name
	 * @param bpp
	 * @param key
	 * @param w
	 * @param h
	 * @return
	 * @throws TJSException
	 */
	public ScanLineProvider loadImage( final String name, int bpp, int key, int w, int h ) throws TJSException;
}
