package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;

/**
 * TODO 未実装
 * KAG の文法に従ってトークンを分割する
 *
 */
public class KAGTokenizer {
	// タグ(コマンド), コメント、ラベル、行頭のタブは無視、改行コード
	public enum KAGTokenType {
		TAG,
		LABEL,
		SCRIPT,
		TEXT,
		COMMENT,
		RETURN
	}
	static class Token {
		public KAGTokenType mType;
		public int mLineNo;
		public String mContents;
		public Token( KAGTokenType type, int lineno, String contents ) {
			mType = type;
			mLineNo = lineno;
			mContents = contents;
		}
	}
	static class TagToken extends Token {
		public TagToken( int lineno, String contents) {
			super(KAGTokenType.TAG, lineno, contents);
		}

		public String getTagName() {
			int index = mContents.indexOf(' '); // 区切り文字は\tの場合もあるので、そちらでも調べる必要あり
			return mContents.substring(0,index);
		}
	}
	static class LabelToken extends Token {
		public LabelToken( int lineno, String contents) {
			super(KAGTokenType.LABEL, lineno, contents);
		}
	}
	static class ScriptToken extends Token {
		public ScriptToken( int lineno, String contents) {
			super( KAGTokenType.SCRIPT, lineno, contents);
		}
	}
	static class CommentToken extends Token {
		public CommentToken( int lineno, String contents) {
			super(KAGTokenType.COMMENT, lineno, contents);
		}
	}
	private ArrayList<Token> mTokenList;
	private char[] mText;

	// テキスト終端は例外処理に任せる
	public void tokenize() {
		StringBuilder builder = new StringBuilder(1024);
		int pos = 0;
		int lineno = 0;
		boolean islinehead = true; // 行のはじめかどうか
		KAGTokenType currentToken = null;
		// スクリプト中かどうかの特殊処理は必要
		while( true ) {
			char c = mText[pos];
			if( islinehead ) {
				if( c == ';' ) { // コメント行
					currentToken = KAGTokenType.COMMENT;
					pos++;
					c = mText[pos];
					while( c != '\r' && c != '\n' ) { builder.append(c); }
					mTokenList.add( new CommentToken( lineno, builder.toString() ) );
					builder.delete(0, builder.length());

					// 改行を処理
					mTokenList.add( new Token( KAGTokenType.RETURN, lineno, null ) );
					lineno++;
					islinehead = true;
					char c1 = mText[pos+1];
					if( c == '\r' && c1 == '\n' ) { pos++; }
					continue;
				} else if( c == '*' ) { // ラベル
					currentToken = KAGTokenType.LABEL;
					pos++;
					c = mText[pos];
					while( c != '\r' && c != '\n' ) { builder.append(c); }
					mTokenList.add( new LabelToken( lineno, builder.toString() ) );
					builder.delete(0, builder.length());

					// 改行を処理
					mTokenList.add( new Token( KAGTokenType.RETURN, lineno, null ) );
					lineno++;
					islinehead = true;
					char c1 = mText[pos+1];
					if( c == '\r' && c1 == '\n' ) { pos++; }
					continue;
				} else if( c == '@' ) { // コマンド
					currentToken = KAGTokenType.TAG;
					pos++;
					c = mText[pos];
					while( c != '\r' && c != '\n' ) { builder.append(c); }
					mTokenList.add( new TagToken( lineno, builder.toString() ) );
					builder.delete(0, builder.length());

					// 改行を処理
					mTokenList.add( new Token( KAGTokenType.RETURN, lineno, null ) );
					lineno++;
					islinehead = true;
					char c1 = mText[pos+1];
					if( c == '\r' && c1 == '\n' ) { pos++; }
					continue;
				} else if( c == '\t') { // インデントは無視
					do {
						pos++;
						c = mText[pos];
					} while( c == '\t' );
				}
			}
			if( c == '[' ) {
				pos++;
				c = mText[pos];
				//if( c == '[' ) TODO 以下未実装
			}

			if( c == '\r' || c == '\n' ) {	// 改行
				mTokenList.add( new Token( KAGTokenType.RETURN, lineno, null ) );
				lineno++;
				pos++;
				islinehead = true;
				char c1 = mText[pos];
				if( c == '\r' && c1 == '\n' ) {
					pos++;
				}
			}
		}
	}
}
