/**
 * Variant をプールする
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.util.ArrayList;


class VariantPool {
	private static final int DEFAULT_SIZE = 64;
	private static final int LIMIT_SIZE = 48;

	private ArrayList<Variant> mPool;

	public VariantPool() {
		mPool = new ArrayList<Variant>(DEFAULT_SIZE);
	}
	public final Variant allocate() {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant();
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			return ret;
		}
	}
	public Variant allocate( int value ) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(value);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set( value );
			return ret;
		}
	}
	public Variant allocate( double value ) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(value);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set( value );
			return ret;
		}
	}
	public Variant allocate( ByteBuffer value ) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(value);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set( value );
			return ret;
		}
	}
	public Variant allocate( String value ) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(value);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set( value );
			return ret;
		}
	}
	public Variant allocate( Variant value ) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(value);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set( value );
			return ret;
		}
	}
	public Variant allocate(Dispatch2 dsp, Dispatch2 dsp2) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(dsp,dsp2);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set(dsp,dsp2);
			return ret;
		}
	}
	public Variant allocate(Dispatch2 dsp) {
		final int len = mPool.size();
		if( len == 0 ) {
			return new Variant(dsp,null);
		} else {
			Variant ret = mPool.get(len-1);
			mPool.remove(len-1);
			ret.set(dsp,null);
			return ret;
		}
	}
	public final void release( Variant va ) {
		if( va == null ) return;
		va.clear();
		final int poolSize = mPool.size();
		if( poolSize < LIMIT_SIZE ) {
			mPool.add(va);
		}
	}
	public final void release( Variant[] va ) {
		if( va == null ) return;
		final int poolSize = mPool.size();
		if( poolSize < LIMIT_SIZE ) {
			final int count = va.length;
			for( int i = 0; i < count; i++ ) {
				va[i].clear();
				mPool.add(va[i]);
			}
		}
	}
}
