package jp.kirikiri.tvp2env;

public class SystemColor {
	private static final int
		clScrollBar = 0x80000000,
		clBackground = 0x80000001,
		clActiveCaption = 0x80000002,
		clInactiveCaption = 0x80000003,
		clMenu = 0x80000004;
	public static final int clWindow = 0x80000005;
	public static final int clWindowFrame = 0x80000006, clMenuText = 0x80000007, clWindowText = 0x80000008, clCaptionText = 0x80000009, clActiveBorder = 0x8000000a, clInactiveBorder = 0x8000000b, clAppWorkSpace = 0x8000000c,
			clHighlight = 0x8000000d, clHighlightText = 0x8000000e, clBtnFace = 0x8000000f, clBtnShadow = 0x80000010, clGrayText = 0x80000011, clBtnText = 0x80000012, clInactiveCaptionText = 0x80000013,
			clBtnHighlight = 0x80000014, cl3DDkShadow = 0x80000015, cl3DLight = 0x80000016, clInfoText = 0x80000017, clInfoBk = 0x80000018, clNone = 0x1fffffff, clAdapt= 0x01ffffff,
			clPalIdx = 0x3000000, clAlphaMat = 0x4000000;

	public static final boolean is_clPalIdx( int n ) {
		return ((n)&0xff000000) == clPalIdx;
	}
	public static final int get_clPalIdx( int n ) {
		return n&0xff;
	}
	public static final boolean is_clAlphaMat( int n ) {
		return ((n)&0xff000000) == clAlphaMat;
	}
	public static final int get_clAlphaMat( int n ) {
		return n&0xffffff;
	}

	public static int colorToRGB( int color ) {
		switch( color ) {
		case clScrollBar:
			return java.awt.SystemColor.scrollbar.getRGB();
		case clBackground:
			return java.awt.SystemColor.desktop.getRGB();
		case clActiveCaption:
			return java.awt.SystemColor.activeCaption.getRGB();
		case clInactiveCaption:
			return java.awt.SystemColor.inactiveCaption.getRGB();
		case clMenu:
			return java.awt.SystemColor.menu .getRGB();
		case clWindow:
			return java.awt.SystemColor.window.getRGB();
		case clWindowFrame:
			return java.awt.SystemColor.windowBorder.getRGB();
		case clMenuText:
			return java.awt.SystemColor.menuText.getRGB();
		case clWindowText:
			return java.awt.SystemColor.windowText.getRGB();
		case clCaptionText:
			return java.awt.SystemColor.activeCaptionText.getRGB();
		case clActiveBorder:
			return java.awt.SystemColor.activeCaptionBorder.getRGB();
		case clInactiveBorder:
			return java.awt.SystemColor.inactiveCaptionBorder.getRGB();
		case clAppWorkSpace:
			// return java.awt.SystemColor.desktop.getRGB(); //
			return 0xffababab; // 該当するものがない模様
		case clHighlight:
			return java.awt.SystemColor.textHighlight.getRGB();
		case clHighlightText:
			return java.awt.SystemColor.textHighlightText.getRGB();
		case clBtnFace:
			return java.awt.SystemColor.control.getRGB();
		case clBtnShadow:
			return java.awt.SystemColor.controlShadow.getRGB();
		case clGrayText:
			return java.awt.SystemColor.textInactiveText.getRGB();
		case clBtnText:
			return java.awt.SystemColor.controlText.getRGB();
		case clInactiveCaptionText:
			return java.awt.SystemColor.inactiveCaptionText.getRGB();
		case clBtnHighlight:
			return java.awt.SystemColor.controlLtHighlight.getRGB();
		case cl3DDkShadow:
			return java.awt.SystemColor.controlDkShadow.getRGB();
		case cl3DLight:
			return java.awt.SystemColor.controlHighlight.getRGB();
		case clInfoText:
			return java.awt.SystemColor.infoText.getRGB();
		case clInfoBk:
			return java.awt.SystemColor.info.getRGB();
		case clNone:
			return 0xffffffff;
		case clAdapt:
			return clAdapt;
		case clPalIdx:
			return clPalIdx;
		case clAlphaMat:
			return clAlphaMat;
		}
		return color; // unknown, passthru
	}
}
