package jp.kirikiri.tjs2;

import java.util.ArrayList;


class ArrayNI extends NativeInstanceObject {

	public ArrayList<Variant> mItems;

	/*
	static class DictionaryEnumCallback extends Dispatch {
		public ArrayList<Variant> mItems;

		public int funcCall( int flag, final String membername, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
			// called from CustomObject::EnumMembers
			if( param.length < 3) return Error.E_BADPARAMCOUNT;

			// hidden members are not processed
			int flags = param[1].asInteger();
			if( (flags & Interface.HIDDENMEMBER) != 0 ) {
				if( result != null ) result.set(1);
				return Error.S_OK;
			}
			// push items
			mItems.add( new Variant(param[0]) );
			mItems.add( new Variant(param[2]) );
			if( result != null ) result.set(1);
			return Error.S_OK;
		}
	};
	*/

	static class DictionaryEnumCallback implements EnumMembersCallback {
		public ArrayList<Variant> mItems;
		public DictionaryEnumCallback( ArrayList<Variant> items ) {
			mItems = items;
		}
		@Override
		public boolean callback( String name, int flags, Variant value ) {
			// hidden members are not processed
			if( (flags & Interface.HIDDENMEMBER) != 0 ) {
				return true;
			}
			// push items
			mItems.add( new Variant(name) );
			mItems.add( new Variant(value) );
			return true;
		}
	};
	public ArrayNI() {
		//super(); // スーパークラスでは何もしていない
		mItems = new ArrayList<Variant>();
	}

	public int construct( Variant[] param, Dispatch2 tjsObj ) {
		// called by TJS constructor
		if( param != null && param.length != 0 ) {
			return Error.E_BADPARAMCOUNT;
		}
		return Error.S_OK;
	}
	public void assign( Dispatch2 dsp ) throws VariantException, TJSException {
		// copy members from "dsp" to "Owner"

		// determin dsp's object type
		//Holder<ArrayNI> arrayni = new Holder<ArrayNI>(null);
		ArrayNI array = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID);
		if( array != null  ) {
			// copy from array
			mItems.clear();
			final int count = array.mItems.size();
			for( int i = 0; i < count; i++ ) {
				mItems.add( new Variant(array.mItems.get(i)) );
			}
			//mItems.addAll( array.mItems );
		} else {
			// convert from dictionary or others
			mItems.clear();
			/*
			DictionaryEnumCallback callback = new DictionaryEnumCallback();
			callback.mItems = mItems;
			dsp.enumMembers( Interface.IGNOREPROP, new VariantClosure( callback, null), dsp);
			*/

			DictionaryEnumCallback callback = new DictionaryEnumCallback( mItems );
			dsp.enumMembers( Interface.IGNOREPROP, callback, dsp );
		}
	}
	public void saveStructuredData( ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, final String indentstr ) throws VariantException, TJSException {
		stream.write( "(const) [\n" );
		String indentstr2 = indentstr + " ";

		final int count = mItems.size();
		for( int i = 0; i < count; i++ ) {
			Variant v = mItems.get(i);
			stream.write(indentstr2);
			if( v.isObject() ) {
				// object
				VariantClosure clo = v.asObjectClosure();
				saveStructuredDataForObject( clo.selectObject(),stack, stream, indentstr2 );
			} else {
				stream.write( Utils.variantToExpressionString(v) );
			}
			if( i != mItems.size() -1) // unless last
				stream.write( ",\n" );
			else
				stream.write( "\n" );
		}
		stream.write(indentstr);
		stream.write("]");
	}
	public static void saveStructuredDataForObject( Dispatch2 dsp, ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, final String indentstr ) throws VariantException, TJSException {
		// check object recursion
		final int count = stack.size();
		for( int i = 0; i < count; i++ ) {
			Dispatch2 d = stack.get(i);
			if( d == dsp ) {
				// object recursion detected
				stream.write( "null /* object recursion detected */" );
				return;
			}
		}

		// determin dsp's object type
		DictionaryNI dicni;
		ArrayNI arrayni;
		if( dsp != null ) {
			dicni = (DictionaryNI) dsp.getNativeInstance( DictionaryClass.ClassID );
			if( dicni != null  ) {
				// dictionary
				stack.add(dsp);
				dicni.saveStructuredData( stack, stream, indentstr );
				stack.remove(stack.size()-1);
				return;
			} else {
				arrayni = (ArrayNI) dsp.getNativeInstance( ArrayClass.ClassID );
				if( arrayni != null ) {
					// array
					stack.add(dsp);
					arrayni.saveStructuredData(stack, stream, indentstr);
					stack.remove(stack.size()-1);
					return;
				} else {
					// other objects
					stream.write( "null /* (object) \"" ); // stored as a null
					Variant val = new Variant(dsp,dsp);
					stream.write( LexBase.escapeC(val.asString()) );
					stream.write( "\" */" );
					return;
				}
			}
		}
		stream.write( "null" );
	}
	public void assignStructure( Dispatch2 dsp, ArrayList<Dispatch2> stack ) throws TJSException, VariantException {
		// assign structured data from dsp

		ArrayNI arrayni = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID);
		if( arrayni != null ) {
			// copy from array
			stack.add(dsp);
			try {
				mItems.clear();
				final int count = arrayni.mItems.size();
				for( int i = 0; i < count; i++ ) {
					Variant v = arrayni.mItems.get(i);
					if( v.isObject() ) {
						// object
						Dispatch2 dsp1 = v.asObject();
						// determin dsp's object type

						//DictionaryNI dicni = null;
						//ArrayNI arrayni1 = null;

						if( dsp1 != null && dsp1.getNativeInstance( DictionaryClass.ClassID ) != null ) {
							//dicni = (DictionaryNI)ni.mValue;
							// dictionary
							boolean objrec = false;
							final int scount = stack.size();
							for( int j = 0; j < scount; j++ ) {
								Dispatch2 d = stack.get(j);
								if( d == dsp1 ) {
									// object recursion detected
									objrec = true;
									break;
								}
							}
							if( objrec ) {
								mItems.add( new Variant() ); // becomes null
							} else {
								Dispatch2 newobj = TJS.createDictionaryObject();
								mItems.add( new Variant(newobj, newobj) );
								DictionaryNI newni;
								if( (newni = (DictionaryNI)newobj.getNativeInstance( DictionaryClass.ClassID )) != null ) {
									newni.assignStructure(dsp1, stack);
								}
							}
						} else if( dsp1 != null && dsp1.getNativeInstance(ArrayClass.ClassID) != null ) {
							// array
							boolean objrec = false;
							final int scount = stack.size();
							for( int j = 0; j < scount; j++ ) {
								Dispatch2 d = stack.get(j);
								if( d == dsp1 ) {
									// object recursion detected
									objrec = true;
									break;
								}
							}
							if( objrec ) {
								mItems.add( new Variant() ); // becomes null
							} else {
								Dispatch2 newobj = TJS.createArrayObject();
								mItems.add( new Variant(newobj, newobj) );
								ArrayNI newni;
								if( (newni = (ArrayNI)newobj.getNativeInstance( ArrayClass.ClassID )) != null ) {
									newni.assignStructure(dsp1, stack);
								}
							}
						} else {
							// other object types
							mItems.add( v );
						}
					} else {
						// others
						mItems.add( v );
					}
				}
			} finally {
				stack.remove( stack.size()-1 );
			}
		} else {
			throw new TJSException( Error.SpecifyDicOrArray );
		}
	}
}
