package jp.kirikiri.tjs2;


public class RandomGeneratorClass extends NativeClass {

	static private final int
		S_OK = 0,
		E_NATIVECLASSCRASH = -1008;
	static private final int NIS_GETINSTANCE = 0x00000002; // get native pointer
	public static int mClassID;

	protected NativeInstance createNativeInstance() {
		return new RandomGeneratorNI();
	}
	public static RandomGeneratorNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (RandomGeneratorNI) holder.mValue;
	}
	public RandomGeneratorClass() throws VariantException, TJSException {
		super("RandomGenerator");
		final String __classname = "Array";
		final int NCM_CLASSID = TJS.registerNativeClass(__classname);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		Class<? extends RandomGeneratorClass> c = getClass();
		registerMethods( c, __classname );
	}
	public static int constructor( Variant result, Variant[] param, Dispatch2 objthis ) throws TJSException, VariantException {
		RandomGeneratorNI _this;
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		_this = (RandomGeneratorNI) holder.mValue;
		if( hr < 0 ) return E_NATIVECLASSCRASH;
		if( _this == null ) return E_NATIVECLASSCRASH;
		hr = _this.construct( param, objthis );
		if( hr < 0 ) return hr;

		_this.randomize( param );
		return S_OK;
	}
	public static int finalize( Variant result, Variant[] param, Dispatch2 objthis ) {
		return S_OK;
	}
	public static int randomize( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		_this.randomize( param );
		return S_OK;
	}
	public static int random( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		// returns 53-bit precision random value x, x is in 0 <= x < 1
		if( result != null ) {
			result.set( _this.random() );
		} else {
			_this.random();
		}
		return S_OK;
	}
	public static int random32( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		// returns 32-bit precision integer value x, x is in 0 <= x <= 4294967295
		if( result != null ) {
			result.set( _this.random32() );
		} else {
			_this.random32();
		}
		return S_OK;
	}
	public static int random63( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		// returns 63-bit precision integer value x, x is in 0 <= x <= 9223372036854775807
		if( result != null ) {
			result.set( _this.random63() );
		} else {
			_this.random63();
		}
		return S_OK;
	}
	public static int random64( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		// returns 64-bit precision integer value x, x is in
		// -9223372036854775808 <= x <= 9223372036854775807
		// Java 実装では、int は32 bitまで
		if( result != null ) {
			result.set( _this.random64() );
		} else {
			_this.random64();
		}
		return S_OK;
	}
	public static int serialize( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		RandomGeneratorNI _this = getNativeInstance(objthis);	// インスタンス所得
		if( _this == null ) return E_NATIVECLASSCRASH;
		// returns 64-bit precision integer value x, x is in
		// -9223372036854775808 <= x <= 9223372036854775807
		if( result != null ) {
			Dispatch2 dsp = _this.serialize();
			result.set( dsp, dsp );
		}
		return S_OK;
	}
}
