package jp.kirikiri.tvp2.env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;

public class RippleTransHandlerProvider implements TransHandlerProvider {

	private static final String TIME = "time";
	private static final String CENTERX = "centerx";
	private static final String CENTERY = "centery";
	private static final String RWIDTH = "rwidth";
	private static final String ROUNDNESS = "roundness";
	private static final String SPEED = "speed";
	private static final String MAXDRIFT = "maxdrift";

	private Variant mVariantRet;
	protected long[] mLogValueRet;

	public RippleTransHandlerProvider() {
		mVariantRet = new Variant();
		mLogValueRet = new long[1];
	}

	@Override
	public String getName() { return "ripple"; }

	@Override
	public BaseTransHandler startTransition(SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h, int[] type) throws TJSException {

		if( type != null && type.length >= 1 ) type[0] = ttExchange; // transition type : exchange
		if( type != null && type.length >= 2 ) type[1] = tutDivisible; // update type : divisible
			// update type : divisible fade
		if( options == null ) return null;

		if(src1w != src2w || src1h != src2h)
			Message.throwExceptionMessage( Message.TransitionLayerSizeMismatch,
				 String.valueOf(src2w) + "x" + src2h,
				 String.valueOf(src1w) + "x" + src1h );

		// オプションを得る
		// retrieve "time" option
		int er = options.getAsNumber( TIME, mLogValueRet );
		if( er < 0 ) Message.throwExceptionMessage( Message.SpecifyOption, TIME );
		long time = mLogValueRet[0];
		if( time < 2) time = 2; // あまり小さな数値を指定すると問題が起きるので

		er = options.getAsNumber( CENTERX, mLogValueRet );
		int centerx = (int) mLogValueRet[0];
		if( er < 0 ) centerx = src1w / 2;

		er = options.getAsNumber( CENTERY, mLogValueRet );
		int centery = (int) mLogValueRet[0];
		if( er < 0 ) centery = src1h / 2;

		if(centerx < 0 || centery < 0 || centerx >= src1w || centery >= src1h )
			Message.throwExceptionMessage( "centerx and centery cannot be out of the image" );

		er = options.getAsNumber( RWIDTH, mLogValueRet );
		int ripplewidth = (int) mLogValueRet[0];
		if( er < 0 ) ripplewidth = 128;

		if(ripplewidth != 16 && ripplewidth != 32 && ripplewidth != 64 && ripplewidth != 128)
			Message.throwExceptionMessage( "rwidth must be 16, 32, 64 or 128" );

		er = options.getValue( ROUNDNESS, mVariantRet );
		float roundness = 1.0f;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			roundness = (float) mVariantRet.asDouble();
		}
		mVariantRet.clear();

		if(roundness <= 0.0)
			Message.throwExceptionMessage( "roundness cannot be nagative or equal to 0" );

		er = options.getValue( SPEED, mVariantRet );
		float speed = 6.0f;
		if( er >= 0 && mVariantRet.isVoid() != true ) {
			speed = (float) mVariantRet.asDouble();
		}
		mVariantRet.clear();

		er = options.getAsNumber( MAXDRIFT, mLogValueRet );
		int maxdrift = (int) mLogValueRet[0];
		if( er < 0 ) maxdrift = 24;

		if(maxdrift < 0 || maxdrift >= 128)
			Message.throwExceptionMessage( "maxdrift cannot be nagative or larger than 127" );

		if( maxdrift >= src1w || maxdrift >= src1h)
			Message.throwExceptionMessage( "maxdrift must be lesser than both image width and height" );

		// オブジェクトを作成
		return new RippleTransHandler(time, layertype, src1w, src1h, centerx, centery, ripplewidth, roundness, speed, maxdrift );
	}

}
