package jp.kirikiri.tvp2.env;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class PadForm extends JFrame {

	/**
	 *
	 */
	private static final long serialVersionUID = -193457542364045737L;

	private static final int DEFAULT_WIDTH = 600;
	private static final int DEFAULT_HEIGHT = 400;

	private JScrollPane mScrollPane;
	private JTextArea mTextArea;
	private JLabel mStatusBar;

	public PadForm() {
		super();
		getContentPane().setLayout(new BorderLayout());

		mTextArea = new JTextArea();

		mScrollPane = new JScrollPane(mTextArea);
		mScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		mScrollPane.setPreferredSize(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT));
		getContentPane().add(mScrollPane, BorderLayout.CENTER);


		mStatusBar = new JLabel();
		getContentPane().add( mStatusBar, BorderLayout.SOUTH );

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
	}

	public void setFreeOnTerminate( boolean t ) {
	}
	public void setExecButtonEnabled( boolean t ) {
	}

	//public void setLines( e.getBlock.getScript() ) {
	public void setLines( String lines ) {
		mTextArea.setText( lines );
		JScrollBar bar = mScrollPane.getVerticalScrollBar();
		if( bar != null ) {
			bar.setMaximum(mTextArea.getLineCount());
		}
	}

	public void goToLine( int pos /*1 + e.getBlock().srcPosToLine( e.getPosition() ) - e.getBlock().getLineOffset()*/ ) {
		mTextArea.setCaretPosition( pos );
		try {
			mTextArea.setSelectionStart( mTextArea.getLineStartOffset(pos) );
			mTextArea.setSelectionEnd( mTextArea.getLineStartOffset(pos+1) );
		} catch (BadLocationException e) {
		}
		Dimension dim = mTextArea.getPreferredScrollableViewportSize();
		int lineheight = (dim.height / mTextArea.getLineCount());
		int y = lineheight * pos;
		mScrollPane.scrollRectToVisible( new Rectangle(0,y,dim.width,lineheight) );
	}
	public void setReadOnly( boolean read ) {
		mTextArea.setEditable( !read );
	}
	public void setStatusText( String mes ) {
		mStatusBar.setText( mes );
	}
	public void setCaption( String caption ) {
		setTitle( caption );
	}
	//public void setVisible( boolean );
}
