package jp.kirikiri.tjs2;

public class TJSScriptError extends TJSException {

	/**
	 *
	 */
	private static final long serialVersionUID = -1727870605938357683L;

	private static final int  MAX_TRACE_TEXT_LEN = 1500;
	class ScriptBlockHolder {
		public ScriptBlockHolder( ScriptBlock block ) {
			mBlock = block;
		}
		protected void finalize() {
			mBlock = null;
		}
		public ScriptBlockHolder( final ScriptBlockHolder holder ) {
			mBlock = holder.mBlock;
		}
		public ScriptBlock mBlock;
	}
	private ScriptBlockHolder mBlock;
	private int mPosition;
	private String mTrace;


	public ScriptBlock getBlock() { return mBlock.mBlock; }

	public int getPosition() { return mPosition; }

	public int GetSourceLine() {
		return mBlock.mBlock.srcPosToLine(mPosition) +1;
	}

	public final String getBlockName() {
		final String name = mBlock.mBlock.getName();
		return name != null ? name : "";
	}

	public final String getTrace() { return mTrace; }

	public boolean addTrace( ScriptBlock block, int srcpos ) {
		int len = mTrace.length();
		if( len >= MAX_TRACE_TEXT_LEN) return false;

		if( len != 0 ) mTrace += " <-- ";
		mTrace += block.getLineDescriptionString(srcpos);
		return true;
	}
	public boolean addTrace( InterCodeContext context, int codepos ) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;

		if(len != 0) mTrace += " <-- ";
		mTrace += context.getPositionDescriptionString(codepos);
		return true;
	}
	public boolean addTrace( final String data ) {
		int len = mTrace.length();
		if(len >= MAX_TRACE_TEXT_LEN) return false;
		if(len != 0) mTrace += " <-- ";
		mTrace += data;
		return true;
	}

	public TJSScriptError( final String Msg, ScriptBlock block, int pos ) {
		super(Msg);
		mBlock = new ScriptBlockHolder(block);
		mPosition = pos;
		mTrace = new String();
	}
	public TJSScriptError( final TJSScriptError ref) {
		mBlock = ref.mBlock;
		mPosition = ref.mPosition;
		mTrace = ref.mTrace;
	}
}
