package jp.kirikiri.tjs2;

public class DictionaryObject extends CustomObject {
	private static final int
	S_OK					= 0,
	E_MEMBERNOTFOUND		= -1001,
	E_INVALIDTYPE			= -1005;

	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		MEMBERMUSTEXIST     = 0x00000400; // member *must* exist ( for Dictionary/Array )

	private static Variant VoidVal;
	public static void initialize() {
		VoidVal = new Variant();
	}
	public DictionaryObject() {
		super();
		mCallFinalize = false;
	}
	/*
	public int funcCall( int flag, final String membername, IntWrapper hint, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		return super.funcCall(flag, membername, hint, result, param, objthis);
	}
	*/

	public int propGet( int flag, final String membername, IntWrapper hint, Variant result, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.propGet(flag, membername, hint, result, objthis);
		if( hr == E_MEMBERNOTFOUND && (flag & MEMBERMUSTEXIST) == 0) {
			if(result != null) result.clear(); // returns void
			return S_OK;
		}
		return hr;
	}
	public int createNew( int flag, final String membername, IntWrapper hint, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.createNew(flag, membername, hint, result, param, objthis);
		if( hr == E_MEMBERNOTFOUND && (flag & MEMBERMUSTEXIST) == 0 )
			return E_INVALIDTYPE; // call operation for void
		return hr;
	}
	public int operation( int flag, final String membername, IntWrapper hint, Variant result, final Variant param, Dispatch2 objthis ) throws VariantException, TJSException {
		int hr = super.operation(flag, membername, hint, result, param, objthis);
		if( hr == E_MEMBERNOTFOUND && (flag & MEMBERMUSTEXIST) == 0 ) {
			// value not found -> create a value, do the operation once more
			hr = super.propSet( MEMBERENSURE, membername, hint, VoidVal, objthis);
			if( hr < 0 ) return hr;
			hr = super.operation(flag, membername, hint, result, param, objthis);
		}
		return hr;
	}
}
