package org.seasar.struts.extension.taglib;

import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;

import org.apache.struts.Globals;
import org.apache.struts.taglib.html.Constants;
import org.apache.struts.taglib.html.LinkTag;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.extension.util.SerializeUtilz;
import org.seasar.struts.taglib.S2Functions;
import org.seasar.struts.taglib.S2LinkTag;
import org.seasar.struts.util.S2ActionMappingUtil;

/**
 * {@link LinkTag} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XLinkTag extends S2LinkTag {

	/** serialVersionUID。 */
	private static final long serialVersionUID = 1L;

	/** ActionForm を引き継ぐ場合、{@code true}。 */
	private boolean transferActionForm;

	/**
	 * ActionForm を引き継ぐ場合、{@code true} を返します。
	 * @return ActionForm を引き継ぐ場合、{@code true}
	 */
	public boolean isTransferActionForm() {
		return this.transferActionForm;
	}

	/**
	 * ActionForm を引き継ぐ場合、{@code true} を設定します。
	 * @param transferActionForm ActionForm を引き継ぐ場合、{@code true}
	 */
	public void setTransferActionForm(boolean transferActionForm) {
		this.transferActionForm = transferActionForm;
	}

	/**
	 * {@inheritDoc}
	 * {@link NamingConvention#getViewRootPath()}　を付与します。
	 * 差分変更ができないため、
	 * {@link S2LinkTag#calculateURL(StringBuffer)}
	 * の処理をコピーして、一部分を修正しています。sastrutsのバージョンアップ時に注意が必要になります。
	 */
	@Override
	protected String calculateURL() throws JspException {
		if (this.href != null) {
			int index = this.href.indexOf(':');
			if (index > -1) {
				return super.calculateURL();
			}
			String url = XFunctions.url(this.href);
			if (this.transaction) {
				HttpSession session = this.pageContext.getSession();
				if (session != null) {
					String token = (String) session.getAttribute(Globals.TRANSACTION_TOKEN_KEY);
					if (token != null) {
						if (url.indexOf("?") < 0) {
							url = url + "?" + Constants.TOKEN_KEY + "=" + token;
						} else {
							url = url + "&" + Constants.TOKEN_KEY + "=" + token;
						}
					}
				}
			}

			return this.calculateCustomURL(url);
		}

		return super.calculateURL();
	}

	/**
	 * カスタムしたURLを算出します。
	 * @param url URL
	 * @return カスタムしたURL
	 */
	protected String calculateCustomURL(String url) {

		if (this.isTransferActionForm()) {

			S2ActionMapping actionMapping = S2ActionMappingUtil.getActionMapping();
			Object form = actionMapping.getActionForm();
			String value = SerializeUtilz.fromObjectToString(form);

			if (value != null) {

				String name = actionMapping.getName();
				url = this.addUrlParam(url, name, value);
			}
		}

		return url;
	}

	/**
	 * urlパラメータを追加します。
	 * @param url 対象URL
	 * @param name 項目名
	 * @param value 項目値
	 * @return パラメータを追加したURL
	 */
	protected String addUrlParam(String url, String name, String value) {

		StringBuffer sb = new StringBuffer(url);
		sb.append(url.indexOf("?") < 0 ? "?" : "&");
		sb.append(S2Functions.u(name));
		sb.append("=");
		sb.append(S2Functions.u(value));
		return sb.toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void release() {

		super.release();

		this.transferActionForm = false;
	}
}
