package org.seasar.struts.extension.taglib;

import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.struts.taglib.S2Functions;
import org.seasar.struts.util.RequestUtil;

/**
 * {@link S2Functions} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XFunctions {

	/**
	 * URLを計算します。
	 * {@link NamingConvention#getViewRootPath()}　を付与します。
	 * @param input 入力値
	 * @return エスケープした結果
	 */
	public static String url(String input) {

		String url = S2Functions.url(input);

		if (input.indexOf('.') != -1) {
			return url;
		}

		NamingConvention namingConvention = SingletonS2Container.getComponent(NamingConvention.class);
		String viewRootPath = namingConvention.getViewRootPath();

		String contextPath = RequestUtil.getRequest().getContextPath();
		url = url.replace(contextPath, contextPath + viewRootPath);

		return url;
	}
}
