#
# spec file for package: SFEperl-lwp
#
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# includes module(s):
#
%include Solaris.inc
%include packagenamemacros.inc

%define tarball_version 6.04
%define tarball_name    LWP

Name:		SFEperl-lwp
IPS_package_name: library/perl-5/lwp
Version:	6.04
IPS_component_version: 6.4
Summary:	Libwww-perl
License:	Artistic
Distribution:   OpenSolaris
Vendor:         OpenSolaris Community
Url:		http://search.cpan.org/~lwwwp/%{tarball_name}-%{tarball_version}
SUNW_Basedir:	%{_basedir}
SUNW_Copyright: %{name}.copyright
Source0:	http://search.cpan.org/CPAN/authors/id/G/GA/GAAS/libwww-perl-%{tarball_version}.tar.gz

BuildRequires:	runtime/perl-584
BuildRequires:	runtime/perl-512

Meta(info.maintainer):          roboporter by pkglabo.justplayer.com <pkgadmin@justplayer.com>
Meta(info.upstream):            The libwww-perl mailing list <libwww@perl.org>
Meta(info.upstream_url):        http://search.cpan.org/~lwwwp/%{tarball_name}-%{tarball_version}
Meta(info.classification):	org.opensolaris.category.2008:Development/Perl

%description
Libwww-perl

%package 584
IPS_package_name: library/perl-5/lwp-584
Summary: Libwww-perl for perl-584
BuildRequires:	runtime/perl-584
BuildRequires:  library/perl-5/http-message-584
BuildRequires:	library/perl-5/net-http-512
Requires:	runtime/perl-584
Requires:       ${IPS_package_name}
Requires:       library/perl-5/http-message-584
Requires:       library/perl-5/http-date-584
Requires:       library/perl-5/net-http-584

%package 512
IPS_package_name: library/perl-5/lwp-512
Summary: Libwww-perl for perl-512
BuildRequires:	runtime/perl-512
BuildRequires:  library/perl-5/http-message-512
BuildRequires:	library/perl-5/net-http-512
Requires:	runtime/perl-512
Requires:       ${IPS_package_name}
Requires:       library/perl-5/http-message-512
Requires:       library/perl-5/http-date-512
Requires:       library/perl-5/net-http-512

%prep
%setup -q -n libwww-perl-%{tarball_version}

%build
export PERL5LIB=/usr/perl5/vendor_perl/5.8.4
/usr/perl5/5.8.4/bin/perl Makefile.PL PREFIX=%{_prefix} \
  DESTDIR=$RPM_BUILD_ROOT \
  LIB=/usr/perl5/vendor_perl/5.8.4
make
make test

rm -rf $RPM_BUILD_ROOT
make pure_install

export PERL5LIB=/usr/perl5/vendor_perl/5.12
/usr/perl5/5.12/bin/perl Makefile.PL PREFIX=%{_prefix} \
  DESTDIR=$RPM_BUILD_ROOT \
  LIB=/usr/perl5/vendor_perl/5.12
make
make test

%install
make pure_install
mkdir -p $RPM_BUILD_ROOT%{_datadir}
mv $RPM_BUILD_ROOT%{_prefix}/man $RPM_BUILD_ROOT%{_datadir}
mv $RPM_BUILD_ROOT%{_datadir}/man/man3 $RPM_BUILD_ROOT%{_datadir}/man/man3perl

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,bin)
#%{_prefix}/perl5
%attr(0755,root,sys) %dir %{_datadir}
%{_mandir}
#%attr(0755,root,bin) %dir %{_bindir}
#%{_bindir}/*

%files 584
%defattr (-, root, bin)
%{_prefix}/perl5/vendor_perl/5.8.4

%files 512
%defattr (-, root, bin)
%{_prefix}/perl5/vendor_perl/5.12

%changelog
* Wed Jan 23 2013 - Fumihisa TONAKA <fumi.ftnk@gmail.com>
- add BuildRequires
* Mon Dec 24 2012 - Fumihisa TONAKA <fumi.ftnk@gmail.com>
- add BuildRequires
* Fri Sep 28 2012 - Fumihisa TONAKA <fumi.ftnk@gmail.com>
- add Requires
* Wed Sep 26 2012 - Fumihisa TONAKA <fumi.ftnk@gmail.com>
- add Requires
* Thu Jun 14 2012 - Fumihisa TONAKA <fumi.ftnk@gmail.com>
- initial commit
