/* テスト */
#ifndef INCLUDED_Z_UTIL_H
#define INCLUDED_Z_UTIL_H

#include "h-basic.h"

/**** Available variables ****/

/**
 * The name of the program.
 */
extern const _TCHAR *argv0;

/* Aux functions */
extern void (*plog_aux)(const _TCHAR *);
extern void (*quit_aux)(const _TCHAR *);

/**** Available Functions ****/

/**
 * Case insensitive comparison between two strings
 */
extern int my_stricmp(const _TCHAR *s1, const _TCHAR *s2);

/**
 * Case insensitive comparison between two strings, up to n characters long.
 */
extern int my_strnicmp(const _TCHAR *a, const _TCHAR *b, int n);

/**
 * Case-insensitive _tcsstr
 */
extern const _TCHAR *my_stristr(const _TCHAR *string, const _TCHAR *pattern);

/* Replace my _strcpy with _tcscpy_s */
#if 0
/**
 * Copy up to 'bufsize'-1 characters from 'src' to 'buf' and NULL-terminate
 * the result.  The 'buf' and 'src' strings may not overlap.
 *
 * Returns: _tcslen(src).  This makes checking for truncation
 * easy.  Example:
 *   if (my _strcpy(buf, src, _countof(buf)) >= _countof(buf)) ...;
 *
 * This function should be equivalent to the strlcpy() function in BSD.
 */
extern size_t my _strcpy(TCHAR *buf, const TCHAR *src, size_t bufsize);
#endif

#if 0
/**
 * Try to append a string to an existing NULL-terminated string, never writing
 * more characters into the buffer than indicated by 'bufsize', and
 * NULL-terminating the buffer.  The 'buf' and 'src' strings may not overlap.
 *
 * my_strcat() returns _tcslen(buf) + _tcslen(src).  This makes checking for
 * truncation easy.  Example:
 *   if (my_strcat(buf, src, _countof(buf)) >= _countof(buf)) ...;
 *
 * This function should be equivalent to the strlcat() function in BSD.
 */
extern size_t my_strcat(_TCHAR *buf, const _TCHAR *src, size_t bufsize);
#endif

/* Test equality, prefix, suffix */
extern bool streq(const _TCHAR *s, const _TCHAR *t);
extern bool prefix(const _TCHAR *s, const _TCHAR *t);
extern bool suffix(const _TCHAR *s, const _TCHAR *t);

#define streq(s, t)		(!_tcscmp(s, t))

/* Print an error message */
extern void plog(const _TCHAR *str);

/* Exit, with optional message */
extern void quit(const _TCHAR *str);

/* Sorting functions */
/* TODO: make ang_sort() take comp and swap hooks rather than use globals */
void ang_sort(void *u, void *v, int n);
void ang_sort_aux(void *u, void *v, int p, int q);

extern bool (*ang_sort_comp)(const void *u, const void *v, int a, int b);
extern void (*ang_sort_swap)(void *u, void *v, int a, int b);

#endif /* INCLUDED_Z_UTIL_H */
