﻿/**
 * @file TrayApp.h
 *
 */

#pragma once

#include "Raym/Raym.h"

#include "keys.h"

#define VERSION "0.05"
#define REVISION 37

namespace ry0
{
namespace iPTd
{

class TrayApp : public Raym::Application
{
private:

    Raym::String *          _system_path;           // システムパス(実行ファイルが配置されているディレクトリ)
    Raym::Dictionary *      _props;                 // プロパティ
    int                     _idle_count;            // アイドルカウンタ

    void notification();

protected:
    TrayApp();
    ~TrayApp();

public:
    static TrayApp *alloc();

    // Windows用IF (from TrayApp)
    int  start();    // エントリポイント
    void systemWillSuspend();
    void systemResumed();
    void detectIdle();
    void detectNonIdle();
    bool canTerminate();
    void debugLog(const char *message);
};

} // iPTd
} // ry0
