﻿/**
 * @file Extractor.h
 *
 */

#pragma once

#include "Raym/Raym.h"
#include "ry0/device/Tuner.h"
#include "mpeg2/ts/Analyzer.h"

namespace ry0
{
namespace iPTd
{

class Extractor : public Raym::Object,
                 public ry0::device::Tuner::Listener,
                 public MPEG2::TS::Analyzer::Listener
{
private:
    MPEG2::TS::Analyzer _analyzer;
    MPEG2::TS::SDT *    _sdt;
    MPEG2::TS::EIT *    _eit;

protected:
    Extractor();
    ~Extractor();

public:
    static Extractor *alloc();
    Extractor *init();

    Raym::Dictionary *stationInfo();
    Raym::Array *collectEPGs(time_t limit);

    // ry0::device::Tuner::Listener
    void put(uint8_t *buffer, uint32_t size);

    // MPEG2::TS::Demultiplexer::Listener
    void detect(MPEG2::TS::PAT *pat);
    void detect(MPEG2::TS::SDT *sdt);
    void detect(MPEG2::TS::EIT *eit);
};

} // iPTd
} // ry0
