//
// TunerFactory.cpp
//

#include "ry0/device/TunerFactory.h"
#include "ry0/device/PT1/PT1Tuner.h"
#include "ry0/device/PT3/PT3Tuner.h"

namespace ry0
{
namespace device
{

int TunerFactory::scan(Tuner *tuners[MAX_TUNERS], HMODULE multi2_dll)
{
    int count = 0;

    // PT1/PT2
    int scanned;
    scanned = ry0::device::PT1::PT1Tuner::scan(&tuners[count], multi2_dll);
    if (scanned > 0)
    {
        count += scanned;
    }

    // PT3
    scanned = ry0::device::PT3::PT3Tuner::scan(&tuners[count], multi2_dll);
    if (scanned > 0)
    {
        count += scanned;
    }

    return count;
}

} // device
} // ry0
