﻿/**
 * @file EIT.h
 *
 */

#pragma once

#include "mpeg2/ts/Table.h"

namespace MPEG2
{

namespace TS
{

class EIT : public Table
{
protected:
    bool decode_section();

public:
    /*
     * 0x4E        : EIT（自ストリームの現在と次の番組）
     * 0x4F        : EIT（他ストリームの現在と次の番組）
     * 0x50 - 0x5F : EIT（自ストリーム、スケジュール）
     * 0x60 - 0x6F : EIT（他ストリーム、スケジュール）
     */
    enum
    {
        TABLE_ID_SELF                   = 0x4E,
        TABLE_ID_OTHER                  = 0x4F,
        TABLE_ID_SELF_SCHEDULE_BEGIN    = 0x50,
        TABLE_ID_SELF_SCHEDULE_END      = 0x5F,
        TABLE_ID_OTHER_SCHEDULE_BEGIN   = 0x60,
        TABLE_ID_OTHER_SCHEDULE_END     = 0x6F
    };

    uint8_t         _table_id;                      //  8
    uint8_t         _section_syntax_indicator;      //  1
                                                    //  1   '1'
                                                    //  2   '11'
    uint16_t        _section_length;                // 12
    uint16_t        _service_id;                    // 16
                                                    //  2   '11'
    uint8_t         _version_number;                //  5
    uint8_t         _current_next_indicator;        //  1
    uint8_t         _section_number;                //  8
    uint8_t         _last_section_number;           //  8
    uint16_t        _transport_stream_id;           // 16
    uint16_t        _original_network_id;           // 16
    uint8_t         _segment_last_section_number;   //  8
    uint8_t         _last_table_id;                 //  8

    class Event
    {

    public:
        uint16_t    _event_id;                      // 16
        // start_time                                  40
        uint16_t    _st_year;
        uint8_t     _st_month;
        uint8_t     _st_day;
        uint8_t     _st_hour;
        uint8_t     _st_min;
        uint8_t     _st_sec;
        // duration                                    24
        uint8_t     _dur_hour;
        uint8_t     _dur_min;
        uint8_t     _dur_sec;
        uint8_t     _running_status;                //  3
        uint8_t     _free_CA_mode;                  //  1
        uint16_t    _descriptors_loop_length;       // 12

        uint8_t *   _descriptor_ptr;
        uint16_t    _descriptor_offset;
        Descriptor  _descriptor;
        Descriptor *nextDescriptor();
    };

    uint8_t     _event_data[MAX_SECT_LEN];
    uint16_t    _event_offset;
    Event       _event;

public:
    EIT();
    EIT(EIT &eit);
    ~EIT();
    void reset();

    Event *nextEvent();
};

} // TS
} // MPEG2
