//
// URL.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/String.h>

namespace Raym
{

class URL : public Object
{
protected:
    URL();
    ~URL();

    String *    _scheme;
    String *    _host;
    int         _port;
    String *    _user;
    String *    _password;
    String *    _path;

public:
    static URL *alloc();
    static URL *URLWithString(String *URLString);
    static URL *URLWithString(const char *URLString);

    URL *initWithString(String *URLString);
    URL *initWithString(const char *URLString);
    URL *retain();

    String *scheme();
    String *host();
    int port();
    String *user();
    String *password();
    String *path();

//    virtual String *description();
    virtual const char *className();
};

} // Raym

