﻿//
//
//

#include <Raym/Object.h>
#include <Raym/Array.h>
#include <Raym/FileHandle.h>

namespace Raym
{

class Task : public Object
{
private:
    bool                _launched;
    String *          _launchPath;
    Array *           _arguments;
    FileHandle *      _standardInput;
    FileHandle *      _standardOutput;
    FileHandle *      _standardError;

#ifdef _WIN32
    PROCESS_INFORMATION _pi;
#endif

protected:
    Task();
    ~Task();

public:
    static Task *alloc();
    Task *init();

    void setLaunchPath(String *launchPath);
    void setArguments(Array *arguments);
    void setStandardInput(FileHandle *standardInput);
    void setStandardOutput(FileHandle *standardOutput);
    void setStandardError(FileHandle *standardError);

    void launch();
    void terminate();
    void waitUntilExit();

    virtual const char *className();
};

} // Raym

