//
// Lock.cpp
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/Lock.h>

namespace Raym
{

Lock *Lock::alloc()
{
    DebugLog2("Lock::alloc()");

    return new Lock();
}

Lock::Lock()
{
    DebugLog2("Lock::Lock()");
}

Lock::~Lock()
{
    DebugLog2("Lock::~Lock()");
}

Lock *Lock::init()
{
    return this;
}

Lock *Lock::retain()
{
    DebugLog2("Lock::retain()");

    Object::retain();
    return this;
}

Lock *Lock::autorelease()
{
    DebugLog2("Lock::autorelease()");

    Object::autorelease();
    return this;
}

void Lock::lock()
{
    RaymLock(this);
}

void Lock::unlock()
{
    RaymUnlock(this);
}

const char *Lock::className()
{
    return "Lock";
}

} // Raym
