﻿//
//
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/Raym.h>

namespace Raym
{

FileHandle::FileHandle()
{
    DebugLog2("FileHandle::FileHandle()");

    _handle = NULL;
}

FileHandle::~FileHandle()
{
    if (_handle != NULL)
    {
        CloseHandle(_handle);
        _handle = NULL;
    }

    DebugLog2("FileHandle::~FileHandle()");
}

FileHandle *FileHandle::fileHandleWithHANDLE(HANDLE h)
{
    DebugLog2("FileHandle::fileHandleWithHANDLE(h)");

    FileHandle *handle = new FileHandle();
    handle->init()->autorelease();
    handle->_handle = h;
    handle->_pipe = (GetNamedPipeInfo(h, NULL, NULL, NULL, NULL) != 0);
    return handle;
}

HANDLE FileHandle::handle()
{
    DebugLog2("FileHandle::handle()");

    return _handle;
}

bool FileHandle::isPipe()
{
    DebugLog2("FileHandle::isPipe()");

    return _pipe;
}

const char *FileHandle::className()
{
    return "FileHandle";
}

} // Raym
