//
// Data.h
//

#ifndef __RAYM_DATA_H__
#define __RAYM_DATA_H__

#include <Raym/Object.h>
#include <Raym/URL.h>

namespace Raym
{

class Data : public Object
{
private:
    UInteger    _length;
    void *      _bytes;

protected:
    Data();
    ~Data();

public:
    static Data *alloc();
    static Data *dataWithCapacity(UInteger aNumItems);
    static Data *dataWithContentsOfFile(const char *path);
    static Data *dataWithContentsOfURL(URL *url);

    Data *initWithCapacity(UInteger aNumItems);
    Data *initWithBytesAndLength(const void *bytes, UInteger length);
    Data *initWithContentsOfFile(String *path);
    Data *initWithContentsOfFile(const char *path);
    Data *initWithContentsOfURL(URL *url);
    Data *retain();
    Data *autorelease();

    UInteger length();
    const void *bytes();

    void appendBytes(const void *bytes, UInteger length);

    virtual const char *className();
};

} // Raym

#endif // __RAYM_DATA_H__
